#!/usr/bin/env python2
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import division

__license__   = 'GPL v3'
__copyright__ = '2010-2012, Timothy Legge <timlegge@gmail.com>, Kovid Goyal <kovid@kovidgoyal.net> and David Forrester <davidfor@internode.on.net>'
__docformat__ = 'restructuredtext en'

'''
Driver for Kobo ereaders. Supports all e-ink devices.

Originally developed by Timothy Legge <timlegge@gmail.com>.
Extended to support Touch firmware 2.0.0 and later and newer devices by David Forrester <davidfor@internode.on.net>
'''

import os, time, shutil, re

from calibre.devices.usbms.driver import USBMS, debug_print
from calibre.devices.kobo.driver import KOBOTOUCH, KOBO
from calibre.constants import DEBUG

EPUB_EXT = '.epub'
KEPUB_EXT = '.kepub'

class KOBOTOUCHBETA(KOBOTOUCH):
    name        = 'KoboTouchBeta'
    gui_name    = KOBOTOUCH.gui_name + ' - Beta'
    author      = 'David Forrester'
#     description = 'Communicate with the Kobo Touch, Glo, Mini, Aura HD, Aura H2O, Glo HD and Touch 2 ereaders. Based on the existing Kobo driver by %s. Beta version for OverDrive' % (KOBO.author)
    description = 'Beta version for OverDrive of ' + KOBOTOUCH.description
#    icon        = I('devices/kobotouch.jpg')
    version = (2, 3, 4)
#    icon        = I('devices/kobotouch.jpg')

    supported_dbversion             = 137
    min_fwversion_overdrive         = (4,  3, 8945)

    def open_linux(self):
        super(KOBOTOUCH, self).open_linux()
        
        # Check the drives have been mounted as expected and swap if needed.
        if self._card_a_prefix is None:
            return
        
        if not self.is_main_drive(self._main_prefix):
            temp_prefix = self._main_prefix
            self._main_prefix = self._card_a_prefix
            self._card_a_prefix = temp_prefix
        
    def osx_sort_names(self, names):
        return self.sort_drives(names)

    def windows_sort_drives(self, drives):
        return self.sort_drives(drives)

    def sort_drives(self, drives):
        if len(drives) < 2:
            return drives
        main = drives.get('main', None)
        carda = drives.get('carda', None)
        if main and carda and not self.is_main_drive(main):
            debug_print('KoboTouch::windows_sort_drives - main=%s, carda=%s' % (main, carda))
            drives['main'] = carda
            drives['carda'] = main
        return drives

    def is_main_drive(self, drive):
        debug_print('KoboTouch::is_main_drive - main_drive=%s, path=%s' % (drive, os.path.join(drive, '.kobo')))
        return os.path.exists(self.normalize_path(os.path.join(drive, '.kobo')))

