#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2012, Ian Stott <I_P_S@hotmail.com>'
__docformat__ = 'restructuredtext en'

import os, traceback
from PyQt5.Qt import QProgressDialog, QTimer
from calibre.gui2 import warning_dialog


class QueueProgressDialog(QProgressDialog):

    def __init__(self, gui, book_ids, target_id, format_order, similarity_algorithm, indexing_method, similarity_col,
                 queue, db):
        QProgressDialog.__init__(self, '', "", 0, len(book_ids), gui)
        self.setWindowTitle('Queueing books for calculating similarity')
        self.setMinimumWidth(500)
        self.book_ids, self.target_id, self.format_order, self.queue, self.db = \
                                    book_ids, target_id, format_order, queue, db
        self.similarity_algorithm, self.indexing_method, self.similarity_custom_column = similarity_algorithm, indexing_method, similarity_col
        self.gui = gui
        self.i, self.bad, self.books_to_scan = 0, [], []
        QTimer.singleShot(0, self.do_book)
        self.exec_()

    def do_book(self):
        book_id = self.book_ids[self.i]
        self.i += 1

        try:
            title = self.db.title(book_id, index_is_id=True)
            
            root = self.db.library_path
            path = self.db.path(book_id, index_is_id=True)
            author   = self.db.authors(book_id, index_is_id=True)
        
            found_format = False
            for format in self.format_order:
                if self.db.has_format(book_id, format, index_is_id=True):
                    try:
                        self.setLabelText(_('Queueing ')+title)
#                        # Copy the book to the temp directory, using book id as filename
#                        dest_file = os.path.join(self.tdir, '%d.%s'%(book_id, format.lower()))
#                        with open(dest_file, 'w+b') as f:
#                            self.db.copy_format_to(book_id, format, f, index_is_id=True)
#                        dest_file = os.path.join(self.tdir, '%d.%s'%(book_id, format.lower()))
#                        dest_file = full_path
                        dest_file = self.db.format_abspath(book_id, format, index_is_id=True)
                        self.books_to_scan.append((book_id, title, format, dest_file))
                        found_format = True
                    except:
                        self.bad.append(book_id)
                    break
            if not found_format:
                self.bad.append(book_id)
        except:
            traceback.print_exc()
            self.bad.append(book_id)

        self.setValue(self.i)
        if self.i >= len(self.book_ids):
            return self.do_queue()
        else:
            QTimer.singleShot(0, self.do_book)

    def do_queue(self):
        self.hide()
        if self.bad != []:
            res = []
            for id in self.bad:
                title = self.db.title(id, True)
                res.append('%s'%title)
            msg = '%s' % '\n'.join(res)
            warning_dialog(self.gui, _('Could not calculate similarity for some books'),
                _('Could not scan %d of %d books, because no ePub or Mobi '
                'source format was found.') % (len(res), len(self.book_ids)),
                msg).exec_()
        self.gui = None
        # Queue a job to process these ePub/Mobi books
        self.queue(self.target_id, self.books_to_scan, self.similarity_algorithm, self.indexing_method, self.similarity_custom_column)
