#!/bin/sh
#
# Idea of igorsk, script by Corwin & igorsk

PATH="/usr/local/bin:/usr/bin:/sbin:/bin:/usr/bin/X11:/usr/games:/usr/local/sony/bin:/usr/sbin"
LD_LIBRARY_PATH="/opt/sony/ebook/application:/lib:/usr/lib:/usr/local/sony/lib:/opt/sony/ebook/lib"
export PATH LD_LIBRARY_PATH

# Intitial variables
# Max Image Size in bytes 7340032 - 100bytes
OPT_IMG_SIZE=7339932

# Temp Working Filesystem
W_FS=/tmp
W_DIR=/tmp/self_upgrade
W_LOG=/tmp/flash.log
RESFILE=/tmp/result.log
M_CARD=`cat /tmp/cardroot`
PRS_VER=`cat /tmp/prsver`

# Binaries
stat_fs=/tmp/bin/stat_fs
date=/bin/date
mkdir=/bin/mkdir
rm=/bin/rm
tar=/bin/tar
mkcramfs=/usr/bin/mkcramfs
mcopy=/tmp/mcopy
#mcopy=/usr/bin/mcopy
chmod=/bin/chmod
du=/usr/bin/du
cut=/usr/bin/cut
nblsdm=/usr/local/sony/bin/nblsdm
umount=/bin/umount
mtdmount=/usr/local/sony/bin/mtdmount

echo -n "Begin flashing -> " > $W_LOG
$date >> $W_LOG

# Copying stat_fs
$mkdir -p /tmp/bin >> $W_LOG 2>&1
$chmod -R ugo+rx /tmp/bin/* >> $W_LOG 2>&1

if [ ! -x $stat_fs ]; then
  echo "No stat_fs found!" >> $W_LOG
  echo -n "1 stat_fs not found." > $RESFILE
  exit 1;
fi

if [ ! -r $W_DIR/new_opt.img ]; then
  echo "No $W_DIR/new_opt.img found!" >> $W_LOG
  echo -n "2 $W_DIR/new_opt.img not found." > $RESFILE
  exit 1;
fi

echo "Checking cramfs image size ...." >> $W_LOG
NEW_IMG_SIZE=`$du -b $W_DIR/new_opt.img | $cut -f 1`
echo "Cramfs image size: $NEW_IMG_SIZE" >> $W_LOG

if [ $NEW_IMG_SIZE -gt $OPT_IMG_SIZE ]; then
  echo "Opt image size is too big!" >> $W_LOG
  echo -n "5 The new cramfs image is too big for flashing." > $RESFILE
  exit 1
fi

echo "Image size is OK" >> $W_LOG

/bin/df -k >> $W_LOG

# Flashing !!!
echo "Flashing Fsk partition with the new image..." >> $W_LOG
if ! $nblsdm create -i $W_DIR/new_opt.img Fsk >> $W_LOG 2>&1; then
  echo "Error while flashing partition!" >> $W_LOG
  echo -n "6 Error while flashing partition! It is recommended to switch to recovery mode and use Sony flasher to flash a stock image." > $RESFILE
  exit 1
fi

echo "Checking flashed partition against the image..." >> $W_LOG
if ! $nblsdm cmp -i $W_DIR/new_opt.img Fsk >> $W_LOG 2>&1; then
  echo "Partition check failed!" >> $W_LOG
  echo -n "7 Partition check failed! It is recommended to retry flashing immediately or switch to recovery mode and use Sony flasher to flash a stock image." > $RESFILE
  exit 1
fi

#following doesn't work
#echo "Unmounting /opt..." >> $W_LOG
#$umount /opt >> $W_LOG 2>&1
#echo "Remounting /opt..." >> $W_LOG
#$mtdmount -t cramfs Fsk /opt >> $W_LOG 2>&1

echo "Reflashing was successful. Rebooting..." >> $W_LOG

$mcopy -pnso $W_LOG $M_CARD/
sleep 1

echo -n "0 Reflashing was successful. Rebooting." > $RESFILE
sync
sync
sync
sync
sync
sync
/sbin/reboot >> $W_LOG 2>&1
