#!/usr/bin/python
#
# Copyright 2008-2009 Huang Ying <huang.ying.caritas@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#

import sys
import pi

def test_all(conf):
    doc = pi.Doc(conf)
    doc.reformat()

def test1(conf, pn):
    doc = pi.Doc(conf)
    iout = pi.ImageOutput(doc)
    page = pi.Page(doc, pn)
    page.divide()
    page.output(iout)

def test2(conf, pn):
    doc = pi.Doc(conf)
    iout = pi.ImageOutput(doc)
    page = pi.BasicPage(doc, pn)
    #page.divide(iout)
    print 'pg_lft', page.bbox[0]
    print 'avg_rln_lft', page.pavg_rln_lft()
    print 'avg_lh', page.pavg_lh()
    print 'avg_il', page.pavg_il()
    page.save_lines_outline()
    doc.dump_text_formats()

def test3(conf, pn):
    doc = pi.Doc(conf)
    iout = pi.ImageOutput(doc)
    page = pi.BasicPage(doc, pn)
    page.save_words_outline()
    doc.dump_text_formats()

def test4(conf, pn, nln):
    doc = pi.Doc(conf)
    page = pi.Page(doc, pn)
    ln = page.lines[nln]
    lnp = page.lines[nln-1]
    lnn = page.lines[nln+1]
    print nln-1, ':',
    lnp.print_chars()
    print nln, ':',
    ln.print_chars()
    print nln+1, ':',
    lnn.print_chars()
    ln.merge(lnp)
    print nln, '1:',
    ln.print_chars()
    ln.merge(lnn)
    print nln, '2:',
    ln.print_chars()
    page.save_lines()

if __name__ == '__main__':
    argc = len(sys.argv)
    if argc == 2:
        test_all(sys.argv[1])
    elif argc == 3:
        test1(sys.argv[1], int(sys.argv[2]))
    else:
        cmd = int(sys.argv[1])
        if cmd == 1:
            test2(sys.argv[2], int(sys.argv[3]))
        elif cmd == 2:
            test3(sys.argv[2], int(sys.argv[3]))
        elif cmd == 3:
            test4(sys.argv[2], int(sys.argv[3]), int(sys.argv[4]))
