#!/bin/sh

file="/mnt/onboard/.kobo/Kobo/Kobo eReader.conf"

locale="hu"
searchstr="ExtraLocales="
section="ApplicationPreferences"

ret=`grep $searchstr "$file"  | sed 's/^.*=//'`
if [ -z "$ret" ]; then
    sed -i "/\[$section\]/a $searchstr$locale" "$file"
else
    if [ "${ret%$locale}" = "$ret" ]; then
        sed -i "s/\($searchstr.*\)/\1, $locale/" "$file"
    fi
fi


state="hu_HU"
searchstr="CurrentLocale="
section="ApplicationPreferences"

ret=`grep $section "$file"`
if [ -z "$ret" ]; then
    echo "" >> "$file"
    echo "[$section]" >> "$file"
fi

ret=`grep $searchstr "$file"  | sed 's/^.*=//'`

if [ -z "$ret" ]; then
    sed -i "/\[$section\]/a $searchstr$state" "$file"
else
    if [ "${ret%$state}" = "$ret" ]; then
        sed -i "s/\($searchstr\)\(.*\)/\1$state/" "$file"
    fi
fi


state="90"
searchstr="numPartialUpdatePageTurns="
section="Reading"

ret=`grep $section "$file"`
if [ -z "$ret" ]; then
    echo "" >> "$file"
    echo "[$section]" >> "$file"
fi

ret=`grep $searchstr "$file"  | sed 's/^.*=//'`

if [ -z "$ret" ]; then
    sed -i "/\[$section\]/a $searchstr$state" "$file"
else
    if [ "${ret%$state}" = "$ret" ]; then
        sed -i "s/\($searchstr\)\(.*\)/\1$state/" "$file"
    fi
fi


rm /etc/udev/rules.d/update_conf.rules
rm /root/update_conf.sh
