/**
 *
 * Copyright (c) 2007 Mitch Reierson.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef PROXY1150_H
#define PROXY1150_H

#include <vector>
#include "dev1150.h"

class Proxy1150 {
 public:

 Proxy1150(std::string host = "") : _host(host)
  {}

  virtual void do_loop();

 protected:

  Dev1150 _dev1150;
  std::string _host;
  int _socket;

  inline void write(std::string data) { _dev1150.write(data); }

  void split(std::string &data, std::vector<std::string> &data_vector, int num_splits);

  void ack(std::string &id, std::string resp);
  inline void ack(std::string &id) { ack(id, ""); }

  void nak(std::string &id, std::string resp);
  inline void nak(std::string &id) { nak(id, ""); }

  // Proxy network methods called by the 1150
  void gethostbyname(std::string &data);
  void socket(std::string &data);
  void connect(std::string &data);
  void send(std::string &data);
  void recv(std::string &data);
  void close(std::string &data);

};

#endif
