@ECHO OFF

IF [%1]==[] (
   ECHO ERROR! No input file specified!
   PAUSE
   GOTO:EOF
)

%~d0
CD %~dp0
CD ..
SET SyncServerRoot=%CD%
CD config

REM ---- Include settings from send2kobo-config.bat
REN send2kobo.conf send2kobo.conf.bat
CALL send2kobo.conf.bat
REN send2kobo.conf.bat send2kobo.conf

CD %~dp0


REM ---- Set up local variables
SET the7zipexe=%CD%\tools\7za920\7za.exe
SET ScriptDir=%CD%
SETLOCAL EnableDelayedExpansion
SET thekobopath=%OutputDir%\temp\mnt\onboard\virtualSD
SET tempSDpath=%OutputDir%\temp\mnt\onboard\.mysd\virtual
SET problems=false

SET FileCount=0
FOR /f "tokens=2 delims=:." %%x IN ('CHCP') DO SET cp=%%x


REM ---- Create output directory if not yet exists.
MD "%thekobopath%"
MD "%tempSDpath%"
MD %OutputDir%\temp\root\

SET SQLScript=SELECT COUNT(*) AS count FROM content WHERE 


REM ---- Work on each file passed as parameter, so multiple files can be used with Send To.
REM ---- Check if the parameter is a directory
 FOR %%I IN (%1) DO IF EXIST %%~sI\NUL (
  FOR /r %%G IN (%1\*.*) DO (
    ECHO "%%I" - "%%G"
    IF NOT EXIST %%~sI\NUL CALL :WorkOnFiles "%%G"
  )

 ) ELSE CALL :WorkOnFiles %*

SET cnt=0
for /f %%A in ('dir /a-d-s-h /b /s "%thekobopath%"') do set /a cnt+=1
echo File count = %cnt%

IF %cnt% == 0 (
  SET problems="true"
  GOTO CleanUp
)

COPY "%ScriptDir%\tools\data\virtual-sd-libs.tar" "%OutputDir%\temp\KoboRoot.tar"

CD "%OutputDir%"

REM ---- creating sql command file to wait for library update finish
ECHO %SQLScript%0; > "%OutputDir%\temp\root\sql-library-check.sql"
ECHO %FileCount% > "%OutputDir%\temp\root\filecount"

CHCP

cscript /nologo %ScriptDir%\tools\Txt2ASCI.vbs "%OutputDir%\temp\root\sql-library-check.sql" "%OutputDir%\temp\root\sql-library-check.sql"
cscript /nologo %ScriptDir%\tools\Txt2ASCI.vbs "%OutputDir%\temp\root\filecount" "%OutputDir%\temp\root\filecount"

 REM ---- clean up
 IF EXIST "%OutputDir%\temp\KoboRoot.tgz" DEL "%OutputDir%\temp\KoboRoot.tgz"
 IF EXIST "%UpdateDir%\KoboRoot.tgz" DEL "%UpdateDir%\KoboRoot.tgz"
 
 REM ---- create tar
 "%the7zipexe%" a "%OutputDir%\temp\KoboRoot.tar" -ttar  "%OutputDir%\temp\*" -r -x^^!*.tar
 IF ERRORLEVEL 1 GOTO errorTAR
 REM ---- create tgz
 "%the7zipexe%" a "%OutputDir%\temp\KoboRoot.tgz" -tgzip  "%OutputDir%\temp\KoboRoot.tar"
 IF ERRORLEVEL 1 GOTO errorTGZ
 SET KoboRootCreated=true
 
 
 COPY "%OutputDir%\temp\KoboRoot.tgz" "%UpdateDir%\KoboRoot.tgz"
 IF EXIST "%UpdateDir%\count_KoboRoot.tgz.txt" DEL "%UpdateDir%\count_KoboRoot.tgz.txt"
 
 REM "%the7zipexe%" a "%UpdateDir%\kobo-update.zip" -tzip  "%OutputDir%\temp\KoboRoot.tgz"
 
:CleanUP 
 
 REM ---- clean up
 CD %OutputDir%
 RD "%OutputDir%\temp" /Q /S

 
IF %problems% NEQ "true" (
ECHO --------------------------------------------------------------
ECHO Update File prepared successfuly. Ready to send epubs to Kobo!
ECHO --------------------------------------------------------------
)
PAUSE
CD %ScriptDir%
GOTO:EOF

:UnknownType
ECHO ERROR Unknown file type %~x1
SET problems=true
GOTO:EOF

:errorTAR
ECHO ERROR while creating KoboRoot.tar
SET problems=true
GOTO:EOF

:errorTGZ
ECHO ERROR while creating KoboRoot.tgz
SET problems=true
GOTO:EOF

:NullParam
ECHO ERROR No input file specified!
GOTO:EOF

:RemoveSpecial
    SET NewName=%~n1
    SET NewName=%NewName:=%
    SET NewName=%NewName:=%
    SET NewName=%NewName:=%
    SET NewName=%NewName:=%
    SET NewName=%NewName:=%
    SET NewName=%NewName:=%
    SET NewName=%NewName:=%
    SET NewName=%NewName:=%
    SET NewName=%NewName:=%
    SET NewName=%NewName:=%
    SET NewName=%NewName:=%
    SET NewName=%NewName:=%
    SET NewName=%NewName:=%
    SET NewName=%NewName:=%
    SET NewName=%NewName:=%
    SET NewName=%NewName:=%
    SET NewName=%NewName:=%
    SET NewName=%NewName:=%
	SET NewName=%NewName:^^!=%
	SET NewName=%NewName:$=%
	SET NewName=%NewName:,=%
	SET NewName=%NewName:.=%
    REM SET NewName=%NewName: =_%    
GOTO:EOF

:CreateZipIt
    ECHO Set objArgs = WScript.Arguments > "_zipIt.vbs"
    ECHO InputFolder = objArgs(0) >> "_zipIt.vbs"
    ECHO ZipFile = objArgs(1) >> "_zipIt.vbs"
    ECHO CreateObject("Scripting.FileSystemObject").CreateTextFile(ZipFile, True).Write "PK" ^& Chr(5) ^& Chr(6) ^& String(18, vbNullChar) >> "_zipIt.vbs"
    ECHO Set objShell = CreateObject("Shell.Application") >> "_zipIt.vbs"
    ECHO Set source = objShell.NameSpace(InputFolder).Items >> "_zipIt.vbs"
    ECHO objShell.NameSpace(ZipFile).CopyHere(source) >> "_zipIt.vbs"
    ECHO wScript.Sleep 2000 >> "_zipIt.vbs"
GOTO:EOF


REM --------- Subroutine WorkOnFiles ------------
:WorkOnFiles


:Loop
IF {%1}=={} GOTO Continue

ECHO %1

REM ---- Check the input type if it's valid for conversion input.
  SET ValidType=False
  SET NonConvertType=False
  FOR %%A IN (%ValidTypes%) DO (
     IF /I %%A==%~x1 SET ValidType=True
  )
  IF %ValidType%==False (
    SHIFT
    GOTO Loop
  )

  
  REM ---- Removing special symbols from filenames  
  CALL :RemoveSpecial %1

  FOR %%A IN (%NonConvertTypes%) DO (
     IF /I %%A==%~x1 SET NonConvertType=True
  )
  IF %NonConvertType%==True (
  REM ---- copy files
     SET NewExtension=%~x1
     COPY %1 "%thekobopath%\%NewName%!NewExtension!"
  REM ---- Convert input files with calibre's CLI ebook-convert.exe  
  )
  
  IF %NonConvertType%==False (
     SET NewExtension=.epub
	 "%CalibreDir%\ebook-convert.exe" %1 "%thekobopath%\%NewName%!NewExtension!" --no-default-epub-cover --title "%~n1"
     REM ECHO "%CalibreDir%\ebook-convert.exe" %1 "%thekobopath%\%NewName%!NewExtension!" --no-default-epub-cover >> log.txt	 
	 CHCP %cp%>NUL
  ) 
  REM --title "%~n1"      
    
  COPY /Y "%thekobopath%\%NewName%!NewExtension!" "%tempSDpath%\%NewName%!NewExtension!"
  REM ECHO COPY /Y "%thekobopath%\%NewName%!NewExtension!" "%tempSDpath%\%NewName%!NewExtension!" >> log.txt
  IF /I %KeepEpubs%==True (
     COPY "%thekobopath%\%NewName%!NewExtension!" "%OutputDir%\%NewName%!NewExtension!"
  )

SET SQLScript=%SQLScript%(ContentID='file:///mnt/onboard/virtualSD/%NewName%.epub') OR 
  
SET /A FileCount+=1  
SHIFT
GOTO Loop
:Continue

GOTO:EOF