@ECHO OFF

ECHO !!!!!!!!!!!!!!!!!!!!!! WARNING !!!!!!!!!!!!!!!!!!!!!!
ECHO Executing this script and connecting Kobo will modify
ECHO the firmware of the Kobo device! This is neccessary
ECHO for the Kobo Sync Server to work. If you haven't made
ECHO a backup of your Kobo device yet, please close this 
ECHO window now, and make a backup of your Kobo eReader!
ECHO It did not happen during developement, but as the 
ECHO worst-case scenario, if something fails, you may 
ECHO need to do a factory reset, and to recover your
ECHO library and settings, a backup is the only solution.
ECHO So only continue, if you are really ready.
ECHO Thank You for reading this warning message.
ECHO !!!!!!!!!!!!!!!!!!!!!! WARNING !!!!!!!!!!!!!!!!!!!!!!

PAUSE

REM GOTO:SkipKobo2

:WaitForKoboLoop1
 SET KoboDrive=
 FOR /f "tokens=1 delims=\ " %%a IN ('mountvol^| %windir%\system32\find ":\"') DO VOL %%a 2>NUL |  %windir%\system32\find /i "KOBOeReader" >NUL 2>&1 && SET KoboDrive=%%a
 IF "%KoboDrive%"=="" (
   ECHO Please plug in your Kobo to a USB port and tap Connect on the eReader!
   PAUSE
   GOTO WaitForKoboLoop1
 ) ELSE (
   ECHO Kobo USB drive letter is %KoboDrive%)
   GOTO:Continue1
)

:Continue1

COPY "tools\data\get-libnickel.tgz" "%KoboDrive%\.kobo\KoboRoot.tgz"

IF EXIST "%KoboDrive%\.kobo\KoboRoot.tgz" (
   ECHO Successfuly prepared Kobo device.
)

"tools\RemoveDrive.exe" %KoboDrive%

ECHO Please unplug and re-plug your Kobo eReader!

:WaitForKoboLoop2
 SET KoboDrive=
 FOR /f "tokens=1 delims=\ " %%a IN ('mountvol^| %windir%\system32\find ":\"') DO VOL %%a 2>NUL |  %windir%\system32\find /i "KOBOeReader" >NUL 2>&1 && SET KoboDrive=%%a
 IF "%KoboDrive%"=="" (
   REM ECHO Please plug in your Kobo to a USB port and tap Connect on the eReader!
   PAUSE
   GOTO WaitForKoboLoop2
 ) ELSE (
   ECHO Kobo USB drive letter is %KoboDrive%)
   GOTO:Continue2
)

:Continue2

IF EXIST "source\libnickel.so.1.0.0" (
   MOVE /Y "source\libnickel.so.1.0.0" "source\libnickel.so.1.0.0.bak"
   ECHO libnickel.so.1.0.0 file already exists in source folder!
   ECHO Backup created -^> libnickel.so.1.0.0.bak
)

IF EXIST "%KoboDrive%\libnickel.so.1.0.0" (
   MOVE /Y "%KoboDrive%\libnickel.so.1.0.0" "source\libnickel.so.1.0.0"
   ECHO libnickel.so.1.0.0 file successfuly fetched from Kobo. 
   ECHO Preparing patch...
) ELSE (
   ECHO ERROR! Couldn't fetch libnickel.so.1.0.0 from Kobo! Exiting...
   PAUSE
   GOTO:EOF
)

:SkipKobo


SETLOCAL

FOR /F "tokens=* USEBACKQ" %%F IN (`hostname`) DO (
SET NewUpdateLink=%%F
)
ECHO Your hostname: %NewUpdateLink%

SET NewUpdateLink=http://%NewUpdateLink%:88/1.0/UpgradeCheck/%%1/%%2/%%3/%%4/%%5

SET "OriginalUpdateLink=https://api.kobobooks.com/1.0/UpgradeCheck/%%1/%%2/%%3/%%4/%%5"

CALL :strlen l1 NewUpdateLink
CALL :strlen l2 OriginalUpdateLink

SET /a diff=%l2%-%l1%
ECHO New Update URL length difference: %diff%

IF %diff% LSS 0 (
 ECHO ERROR! Hostname too long! Your hostname must be less than 17 characters!
 PAUSE
 GOTO:EOF
)

IF %diff% GTR 0 (
 ECHO Adding %diff% fill-up characters to New Update URL...
)

SETLOCAL EnableDelayedExpansion

FOR /L %%I IN (1,1,%diff%) DO (
  SET NewUpdateLink=!NewUpdateLink!X
)


ECHO New Update URL: %NewUpdateLink%

:: string terminator: chose something that won't show up in the input file
SET strterm=___ENDOFSTRING___
:: read first line of input file
:: add string terminator to input
SET tmp=%NewUpdateLink%%strterm%
SET NewUpdateLink=
:loop
:: get first character from input
SET char=%tmp:~0,1%
:: remove first character from input
SET tmp=%tmp:~1%

:: do something with %char%, e.g. simply print it out
SET NewUpdateLink=%NewUpdateLink%%char%\0

:: repeat until only the string terminator is left
IF NOT "%tmp%" == "%strterm%" GOTO loop


REM ---- Creating new patch file ------

IF EXIST "source\libnickel.so.1.0.0.patch" DEL "source\libnickel.so.1.0.0.patch"
COPY /Y "source\libnickel.so.1.0.0.prep" "source\libnickel.so.1.0.0.patch"
IF NOT EXIST "source\libnickel.so.1.0.0.patch" (
  ECHO ERROR! Couldn't prepare patch file!
  PAUSE
  GOTO:EOF
)

ECHO replace_string = 0000, `h\0t\0t\0p\0s\0:\0/\0/\0a\0p\0i\0.\0k\0o\0b\0o\0b\0o\0o\0k\0s\0.\0c\0o\0m\0/\01\0.\00\0/\0U\0p\0g\0r\0a\0d\0e\0C\0h\0e\0c\0k\0/\0%%\01\0/\0%%\02\0/\0%%\03\0/\0%%\04\0/\0%%\05\0`, `%NewUpdateLink%` >> "source\libnickel.so.1.0.0.patch"
ECHO ^</Patch^> >> "source\libnickel.so.1.0.0.patch"

ECHO Patch file prepared.

ENDLOCAL

CALL patch-kobo.bat

IF "%problems%" NEQ "true" (
   ECHO libnickel.so.1.0.0 patched successfuly!
) ELSE (
   ECHO ERROR! Something went wrong while patching! Exiting.
   PAUSE
   GOTO:EOF
)


:WaitForKoboLoop3
 SET KoboDrive=
 FOR /f "tokens=1 delims=\ " %%a IN ('mountvol^| %windir%\system32\find ":\"') DO VOL %%a 2>NUL |  %windir%\system32\find /i "KOBOeReader" >NUL 2>&1 && SET KoboDrive=%%a
 IF "%KoboDrive%"=="" (
   ECHO Please plug in your Kobo to a USB port and tap Connect on the eReader!
   PAUSE
   GOTO WaitForKoboLoop3
 ) ELSE (
   ECHO Kobo USB drive letter is %KoboDrive%)
   GOTO:Continue3
)

:Continue3



IF EXIST "target\KoboRoot.tgz" (
   COPY "target\KoboRoot.tgz" "%KoboDrive%\.kobo\KoboRoot.tgz"
) ELSE (
   ECHO ERROR! target\KoboRoot.tgz missing!
   PAUSE
   GOTO:EOF
)


IF EXIST "%KoboDrive%\.kobo\KoboRoot.tgz" (
   ECHO Successfuly prepared Kobo device.
) ELSE (
   ECHO ERROR! Failed to copy KoboRoot.tgz to Kobo!
   PAUSE
   GOTO:EOF
)

PING 1.1.1.1 -n 1 -w 10000

"tools\RemoveDrive.exe" %KoboDrive%

ECHO Please unplug your Kobo now.
ECHO After updating and restarting, your Kobo is ready to use with the custom Sync Server running on this PC.
ECHO Enjoy.



:SkipKobo2

CMD /U /C "install-send2kobo.bat"

ECHO Shortcut created to Send To right-click menu!

PAUSE


GOTO:EOF



REM -------- Functions --------

:strlen <resultVar> <stringVar>
(   
    setlocal EnableDelayedExpansion
    set "s=!%~2!#"
    set "len=0"
    for %%P in (4096 2048 1024 512 256 128 64 32 16 8 4 2 1) do (
        if "!s:~%%P,1!" NEQ "" ( 
            set /a "len+=%%P"
            set "s=!s:~%%P!"
        )
    )
)
( 
    endlocal
    set "%~1=%len%"
    exit /b
)
