#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai

from __future__ import with_statement
__license__ = 'GPL v3'

# Standard Python modules.
import os, sys, re, hashlib
import json
import traceback

from calibre.utils.config import dynamic, config_dir, JSONConfig
from calibre_plugins.getfilename.__init__ import PLUGIN_NAME, PLUGIN_VERSION
from calibre.constants import iswindows, isosx
from calibre.utils.date import UNDEFINED_DATE

class GetFileName_Prefs():
    def __init__(self):
        JSON_PATH = os.path.join(u"plugins", PLUGIN_NAME.strip().lower().replace(' ', '_') + '.json')
        self.getfilenameprefs = JSONConfig(JSON_PATH)
		
        self.getfilenameprefs.defaults['configured'] = False
        self.getfilenameprefs.defaults['nom_col'] = ""
        self.getfilenameprefs.defaults['ext_col'] = ""
        self.getfilenameprefs.defaults['path_col'] = ""
        self.getfilenameprefs.defaults['opc_name'] = "file"
        self.getfilenameprefs.defaults['procesados'] = {}
        self.getfilenameprefs.defaults['date_col'] = ""
		
		#if self.getfilenameprefs['procesados'] == {}:
		# self.getfilenameprefs['procesados'] = {}
		
    def __getitem__(self,kind = None):
        if kind is not None:
            return self.getfilenameprefs[kind]
        return self.getfilenameprefs

    def set(self, kind, value):
        self.getfilenameprefs[kind] = value

    def writeprefs(self,value = True):
        self.getfilenameprefs['configured'] = value

    def addnamedvaluetoprefs(self, prefkind, keyname, keyvalue):
        try:
            if keyvalue not in self.getfilenameprefs[prefkind].values():
                # ensure that the keyname is unique
                # by adding a number (starting with 2) to the name if it is not
                namecount = 1
                newname = keyname
                while newname in self.getfilenameprefs[prefkind]:
                    namecount += 1
                    newname = "{0:s}_{1:d}".format(keyname,namecount)
                # add to the preferences
                self.getfilenameprefs[prefkind][newname] = keyvalue
                return (True, newname)
        except:
            traceback.print_exc()
            pass
        return (False, keyname)

    def addvaluetoprefs(self, prefkind, prefsvalue):
        # ensure the keyvalue isn't already in the preferences
        try:
            if prefsvalue not in self.getfilenameprefs[prefkind]:
                self.getfilenameprefs[prefkind].append(prefsvalue)
                return True
        except:
            traceback.print_exc()
        return False
