-- usage:
--    $ sqlite3 /mnt/onboard/.kobo/KoboReader.sqlite < library-virtual-sd.trigger

-- clean up previous versions of the triggers
DROP TRIGGER IF EXISTS update_library_virtual_content;
DROP TRIGGER IF EXISTS update_library_virtual_activity;
DROP TRIGGER IF EXISTS update_library_virtual_event;
DROP TRIGGER IF EXISTS update_library_virtual_volume_shortcovers;

-- create trigger for the content table
CREATE TRIGGER IF NOT EXISTS update_library_virtual_content AFTER INSERT ON content
BEGIN
 UPDATE content SET 
	ContentID = REPLACE(new.ContentID,'/mnt/sd/virtual/','/mnt/onboard/virtualSD/'), 
	BookID = REPLACE(new.BookID,'/mnt/sd/virtual/','/mnt/onboard/virtualSD/'), 
	ImageId = REPLACE(new.ImageId,'_mnt_sd_virtual_','_mnt_onboard_'), 
	ChapterIDBookmarked = REPLACE(new.ChapterIDBookmarked,'/mnt/sd/virtual/','/mnt/onboard/virtualSD/') 
   WHERE rowid = new.rowid;
END;

-- create trigger for the Activity table
CREATE TRIGGER IF NOT EXISTS update_library_virtual_activity AFTER INSERT ON Activity
BEGIN
 UPDATE Activity SET Id = REPLACE(Id,'/mnt/sd/virtual/','/mnt/onboard/virtualSD/') WHERE rowid = new.rowid;
END;

-- create trigger for the Event table
CREATE TRIGGER IF NOT EXISTS update_library_virtual_event AFTER INSERT ON Event
BEGIN
 UPDATE Event SET ContentID = REPLACE(new.ContentID,'/mnt/sd/virtual/','/mnt/onboard/virtualSD/') WHERE rowid = new.rowid;
END;

-- create trigger for the volume_shortcovers table
CREATE TRIGGER IF NOT EXISTS update_library_virtual_volume_shortcovers AFTER INSERT ON volume_shortcovers
BEGIN
 UPDATE Event SET 
	volumeId = REPLACE(new.volumeId,'/mnt/sd/virtual/','/mnt/onboard/virtualSD/'), 
	shortcoverId = REPLACE(new.shortcoverId,'/mnt/sd/virtual/','/mnt/onboard/virtualSD/') 
   WHERE rowid = new.rowid;
END;