#!/bin/sh
# Created by Hape
# 
# Based on code from twobob
# https://www.mobileread.com/forums/showpost.php?p=2849789&postcount=16 
# and NiLuJe
# https://www.mobileread.com/forums/showpost.php?p=2856062&postcount=44
# and encol
# https://www.mobileread.com/forums/showpost.php?p=3326054&postcount=1541



# We need to get the proper constants for our model...
kmodel="$(cut -c3-4 /proc/usid)"
case "${kmodel}" in
	"01" )
		devicemodel="Kindle 1"
	;;
	"02" )
		devicemodel="Kindle 2 U.S."
	;;
	"03" )
		devicemodel="Kindle 2 International"
	;;
	"04" )
		devicemodel="Kindle DX U.S."
	;;
	"05" )
		devicemodel="Kindle DX International"
	;;
	"09" )
		devicemodel="Kindle DX Graphite"
	;;
	"08" )
		devicemodel="Kindle 3 WiFi"
	;;
	"06" )
		devicemodel="Kindle 3 3G U.S."
	;;
	"0A" )
		devicemodel="Kindle 3 3G Europe"
	;;
	"0E" )
		devicemodel="Silver Kindle 4"
	;;
	"0F" )
		devicemodel="Kindle Touch 3G U.S"
	;;
	"11" )
		devicemodel="Kindle Touch WiFi"
	;;
	"10" )
		devicemodel="Kindle Touch 3G Europe"
	;;
	"12" )
		devicemodel="Kindle 5 (Unknown)"
	;;
	"23" )
		devicemodel="Black Kindle 4"
	;;
	"24" )
		devicemodel="Kindle PaperWhite WiFi"
	;;
	"1B" )
		devicemodel="Kindle PaperWhite 3G U.S."
	;;
	"20" )
		devicemodel="Kindle PaperWhite 3G Brazil"
	;;
	"1C" )
		devicemodel="Kindle PaperWhite 3G Canada"
	;;
	"1D" )
		devicemodel="Kindle PaperWhite 3G Europe"
	;;
	"1F" )
		devicemodel="Kindle PaperWhite 3G Japan"
	;;
	"D4" )
		devicemodel="Kindle PaperWhite 2 WiFi U.S & Intl"
	;;
	"5A" )
		devicemodel="Kindle PaperWhite 2 WiFi Japan"
	;;
	"D5" )
		devicemodel="Kindle PaperWhite 2 3G U.S."
	;;
	"D6" )
		devicemodel="Kindle PaperWhite 2 3G Canada"
	;;
	"D7" )
		devicemodel="Kindle PaperWhite 2 3G Europe"
	;;
	"D8" )
		devicemodel="Kindle PaperWhite 2 3G Russia"
	;;
	"F2" )
		devicemodel="Kindle PaperWhite 2 3G Japan"
	;;
	"17" )
		devicemodel="Kindle PaperWhite 2 WiFi 4GB Europe"
	;;
	"60" )
		devicemodel="Kindle PaperWhite 2 3G 4GB Europe"
	;;
	"F4" )
		devicemodel="Unknown Kindle PaperWhite 2 (0xF4)"
	;;
	"F9" )
		devicemodel="Unknown Kindle PaperWhite 2 (0xF9)"
	;;
	"62" )
		devicemodel="Kindle PaperWhite 2 3G 4GB U.S."
	;;
	"61" )
		devicemodel="Kindle PaperWhite 2 3G 4GB Brazil"
	;;
	"5F" )
		devicemodel="Kindle PaperWhite 2 3G 4GB Canada"
	;;
	"C6" )
		devicemodel="Kindle Basic"
	;;
	"DD" )
		devicemodel="Kindle Basic Australia"
	;;
	"13" )
		devicemodel="Kindle Voyage WiFi"
	;;
	"54" )
		devicemodel="Kindle Voyage 3G U.S."
	;;
	"2A" )
		devicemodel="Kindle Voyage 3G Japan"
	;;
	"4F" )
		devicemodel="Unknown Kindle Voyage (0x4F)"
	;;
	"52" )
		devicemodel="Kindle Voyage 3G Mexico"
	;;
	"53" )
		devicemodel="Kindle Voyage 3G Europe"
	;;
	* )
		# Try the new device ID scheme...
		kmodel="$(cut -c4-6 /proc/usid)"
		case "${kmodel}" in
			"0G1" )
				devicemodel="Kindle PaperWhite 3 WiFi"
			;;
			"0G2" )
				devicemodel="Kindle PaperWhite 3 3G U.S."
			;;
			"0G4" )
				devicemodel="Kindle PaperWhite 3 3G Mexico"
			;;
			"0G5" )
				devicemodel="Kindle PaperWhite 3 3G Europe"
			;;
			"0G6" )
				devicemodel="Kindle PaperWhite 3 3G Canada"
			;;
			"0G7" )
				devicemodel="Kindle PaperWhite 3 3G Japan"
			;;
			"0KB" )
				devicemodel="White Kindle PaperWhite 3 WiFi"
			;;
			"0KC" )
				devicemodel="White Kindle PaperWhite 3 3G Japan"
			;;
			"0KD" )
				devicemodel="Unknown White Kindle PaperWhite 3 (0KD)"
			;;
			"0KE" )
				devicemodel="Unknown White Kindle PaperWhite 3 (0KE)"
			;;
			"0KF" )
				devicemodel="Unknown White Kindle PaperWhite 3 (0KF)"
			;;
			"0KG" )
				devicemodel="Unknown White Kindle PaperWhite 3 (0KG)"
			;;
			"0GC" )
				devicemodel="Kindle Oasis WiFi"
			;;
			"0GD" )
				devicemodel="Kindle Oasis 3G U.S."
			;;
			"0GR" )
				devicemodel="Unknown Kindle Oasis (0GR)"
			;;
			"0GS" )
				devicemodel="Unknown Kindle Oasis (0GS)"
			;;
			"0GT" )
				devicemodel="Unknown Kindle Oasis (0GT)"
			;;
			"0GU" )
				devicemodel="Kindle Oasis 3G Europe"
			;;
			"0DU" )
				devicemodel="Unknown Kindle Basic 2 (0DU)"
			;;
			"0K9" )
				devicemodel="Kindle Basic 2"
			;;
			"0KA" )
				devicemodel="White Kindle Basic 2"
			;;
			* )
				devicemodel="Unknown"
			;;
		esac
	;;
esac
case "${kmodel}" in
	"13" | "54" | "2A" | "4F" | "52" | "53" )
		# Voyage...
		SCREEN_X_RES=1088	# NOTE: Yes, 1088, not 1072 or 1080...
		SCREEN_Y_RES=1448
		EIPS_X_RES=16
		EIPS_Y_RES=24		# Manually mesured, should be accurate.
	;;
	"24" | "1B" | "1D" | "1F" | "1C" | "20" | "D4" | "5A" | "D5" | "D6" | "D7" | "D8" | "F2" | "17" | "60" | "F4" | "F9" | "62" | "61" | "5F" )
		# PaperWhite...
		SCREEN_X_RES=768	# NOTE: Yes, 768, not 758...
		SCREEN_Y_RES=1024
		EIPS_X_RES=16
		EIPS_Y_RES=24		# Manually mesured, should be accurate.
	;;
	"C6" | "DD" )
		# KT2...
		SCREEN_X_RES=608
		SCREEN_Y_RES=800
		EIPS_X_RES=16
		EIPS_Y_RES=24
	;;
	"0F" | "11" | "10" | "12" )
		# Touch
		SCREEN_X_RES=600	# _v_width @ upstart/functions
		SCREEN_Y_RES=800	# _v_height @ upstart/functions
		EIPS_X_RES=12		# from f_puts @ upstart/functions
		EIPS_Y_RES=20		# from f_puts @ upstart/functions
	;;
	# Try the new device ID scheme... kmodel always points to our actual device code, no matter the scheme.
	"0G1" | "0G2" | "0G4" | "0G5" | "0G6" | "0G7" | "0KB" | "0KC" | "0KD" | "0KE" | "0KF" | "0KG" )
		# PW3... NOTE: Hopefully matches the KV...
		SCREEN_X_RES=1088	# NOTE: Yes, 1088, not 1072 or 1080...
		SCREEN_Y_RES=1448
		EIPS_X_RES=16
		EIPS_Y_RES=24		# Manually mesured, should be accurate.
	;;
	"0GC" | "0GD" | "0GR" | "0GS" | "0GT" | "0GU" )
		# Oasis... NOTE: Hopefully matches the KV...
		SCREEN_X_RES=1088	# NOTE: Yes, 1088, not 1072 or 1080...
		SCREEN_Y_RES=1448
		EIPS_X_RES=16
		EIPS_Y_RES=24		# Manually mesured, should be accurate.
	;;
	"0DU" | "0K9" | "0KA" )
		# KT3... NOTE: Hopefully matches the KT2...
		SCREEN_X_RES=608
		SCREEN_Y_RES=800
		EIPS_X_RES=16
		EIPS_Y_RES=24
	;;
	* )
		# Handle legacy devices...
		if [ -f "/etc/rc.d/functions" ] && grep "EIPS" "/etc/rc.d/functions" > /dev/null 2>&1 ; then
			. /etc/rc.d/functions
		else
			# Fallback... We shouldn't ever hit that.
			SCREEN_X_RES=600
			SCREEN_Y_RES=800
			EIPS_X_RES=12
			EIPS_Y_RES=20
		fi
	;;
esac
# And now we can do the maths ;)
EIPS_MAXCHARS="$((${SCREEN_X_RES} / ${EIPS_X_RES}))"
EIPS_MAXLINES="$((${SCREEN_Y_RES} / ${EIPS_Y_RES}))"
export POS="$((${EIPS_MAXCHARS} - 12))"
export ROW="${1}"

echo "Device: ${devicemodel}"
echo "Model: ${kmodel}"
echo "x: ${SCREEN_X_RES} max: ${EIPS_MAXCHARS} pos: ${POS}"



if [ "$kmodel" == "01" ] || [ "$kmodel" == "02" ] || [ "$kmodel" == "03" ] || [ "$kmodel" == "04" ] || [ "$kmodel" == "05" ] || [ "$kmodel" == "06" ] || [ "$kmodel" == "08" ] || [ "$kmodel" == "09" ] || [ "$kmodel" == "0A" ]; then
	echo "old device"
	if [ "$2" == "1" ]; then
		# This next part says, "Clear Log" then 
		# "Push the new log, line by line, into awk" then 
		# "If a certain line is matched by awk get awk to run eips via the shell"	
		&> /var/log/messages && 2>/dev/null tail -f /var/log/messages | \
	        awk '/.*PageAction*./ || /.*acxmgrd*./ || /.*NextPage*./ || /.*Reader*./ {system("eips ${POS} ${ROW} `date +%H:%M`-`gasgauge-info -s`")}'
		exit 0
	else
		# This next part says, "Clear Log" then 
		# "Push the new log, line by line, into awk" then 
		# "If a certain line is matched by awk get awk to run eips via the shell"	
		&> /var/log/messages && 2>/dev/null tail -f /var/log/messages | \
	        awk '/.*PageAction*./ || /.*acxmgrd*./ || /.*NextPage*./ || /.*Reader*./ {system("eips ${POS} ${ROW} `date +%H:%M`")}'
		exit 0
	fi	
else 
	echo "New device"
	if [ "$2" == "1" ]; then
		# This next part says, "Clear Log" then 
		# "Push the new log, line by line, into awk" then 
		# "If a certain line is matched by awk get awk to run eips via the shell"	
		&> /var/log/messages && 2>/dev/null tail -F /var/log/messages | exec parselog | \
		awk '/.*PageTurnAction*./ || /.*JunoExecutionManager*./  {system("eips ${POS} ${ROW} `date +%H:%M`-`gasgauge-info -s`")}'
		exit 0
	else
		# This next part says, "Clear Log" then 
		# "Push the new log, line by line, into awk" then 
		# "If a certain line is matched by awk get awk to run eips via the shell"	
		&> /var/log/messages && 2>/dev/null tail -F /var/log/messages | exec parselog | \
		awk '/.*PageTurnAction*./ || /.*JunoExecutionManager*./  {system("eips ${POS} ${ROW} `date +%H:%M`")}'
		exit 0
	fi
fi


