#!/bin/sh

cd `/usr/bin/dirname $0`
DOCPATH=`sed -n -f description.sed ../Path/manifest.xml`

if ! [ -d "$DOCPATH" ]; then exit 1; fi

items=`find "$DOCPATH" -type d | sed 1d`

IFS="
"

for item in $items
do 
	itemstripped=`echo "$item" | sed -n "s/.*\/\(.*\)/\1/p"`
	if echo "$itemstripped" | grep "^_\+"> /dev/null
	then
		itemstripped=`echo "$itemstripped" | sed "s/^_//"`
		pathstripped=`echo "$item" | sed -n "s/\(.*\)\/.*/\1/p"`
		mv -f "$item/" "$pathstripped/$itemstripped/"
	fi
done



