#!/bin/sh

cd `/usr/bin/dirname $0`
DOCPATH=`sed -n -f description.sed ../Path/manifest.xml`
TAG=`sed -n -f description.sed ../Tag/manifest.xml`

if ! [ -d "$DOCPATH" ]; then exit 1; fi

items=`find "$DOCPATH" -type d | sed 1d`

IFS="
"

for item in $items
do 
	if sed -n -f description.sed "$item/manifest.xml" | ./greptagged $TAG > /dev/null
	then
		itemstripped=`echo "$item" | sed -n "s/.*\/\(.*\)/\1/p" | sed "s/_*//"`
		pathstripped=`echo "$item" | sed -n "s/\(.*\)\/.*/\1/p"`
		if [ "$item/" != "$pathstripped/_$itemstripped/" ]; then
			mv -f "$item/" "$pathstripped/_$itemstripped/"
		fi
	fi
done



