#!/usr/bin/env python
import os, codecs, tkinter.filedialog
from epub_utils import epub_zip_up_book_contents

# DiapDealer's temp folder code
from contextlib import contextmanager
@contextmanager
def make_temp_directory():
    import tempfile
    import shutil
    temp_dir = tempfile.mkdtemp()
    yield temp_dir
    shutil.rmtree(temp_dir)

def run(bk):
    unpacked_epub = tkinter.filedialog.askdirectory(title = 'Select the epub folder.')
    if unpacked_epub is not None and os.path.isfile(os.path.join(unpacked_epub, 'mimetype')):
        with make_temp_directory() as epub_td:
            epub_path = os.path.join(epub_td, 'temp.epub')
            epub_zip_up_book_contents(unpacked_epub, epub_path)
            with codecs.open(epub_path, 'rb') as fp:
                data = fp.read()
            bk.addotherfile('dummy.epub', data)
        return 0
    else:
        print('Folder selection error.')
        return -1

def main():
    print('I reached main when I should not have\n')
    return -1

if __name__ == "__main__":
    sys.exit(main())
