#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)
 
__license__   = 'GPL v3'
__copyright__ = '2017, Wrangly <andreatos@gmail.com>, Kloon <kloon@techgeek.co.in>'
__docformat__ = 'restructuredtext en'

#added 3 lines to port to QT5
try:
    from PyQt5 import Qt as QtGui
except ImportError:
    from PyQt4 import QtGui
#added 3 lines to port to QT5
try:
    from PyQt5.Qt import QLabel, QGridLayout, Qt, QGroupBox, QCheckBox
except ImportError:
    from PyQt4.Qt import QLabel, QGridLayout, Qt, QGroupBox, QCheckBox
from calibre.gui2.metadata.config import ConfigWidget as DefaultConfigWidget
from calibre.utils.config import JSONConfig

STORE_NAME = 'Options'
KEY_MAX_DOWNLOADS = 'maxDownloads'
KEY_GET_ALL_AUTHORS = 'getAllAuthors'
KEY_GET_ALL_TAGS = 'getAllTags'


DEFAULT_STORE_VALUES = {
    KEY_MAX_DOWNLOADS: 3,
    KEY_GET_ALL_AUTHORS: True,
	KEY_GET_ALL_TAGS: True
}

# This is where all preferences for this plugin will be stored
plugin_prefs = JSONConfig('plugins/Biblionet_gr')

# Set defaults
plugin_prefs.defaults[STORE_NAME] = DEFAULT_STORE_VALUES


class ConfigWidget(DefaultConfigWidget):

    def __init__(self, plugin):
        DefaultConfigWidget.__init__(self, plugin)
        c = plugin_prefs[STORE_NAME]

        other_group_box = QGroupBox('Επιλογές', self)
        self.l.addWidget(other_group_box, self.l.rowCount(), 0, 1, 2)
        other_group_box_layout = QGridLayout()
        other_group_box.setLayout(other_group_box_layout)

        max_label = QLabel('Μέγιστα αποτελέσματα.(1 = γρήγορο, 20 = αργό):', self)
        max_label.setToolTip('Ο μέγιστος αριθμός αποτελεσμάτων κατά την αναζήτηση')
        other_group_box_layout.addWidget(max_label, 0, 0, 1, 1)
        self.max_downloads_spin = QtGui.QSpinBox(self)
        self.max_downloads_spin.setMinimum(1)
        self.max_downloads_spin.setMaximum(20)
        self.max_downloads_spin.setProperty('value', c.get(KEY_MAX_DOWNLOADS, DEFAULT_STORE_VALUES[KEY_MAX_DOWNLOADS]))
        other_group_box_layout.addWidget(self.max_downloads_spin, 0, 1, 1, 1)
        other_group_box_layout.setColumnStretch(2, 1)

        self.all_authors_checkbox = QCheckBox('Αναζήτηση ονόματος με την ιδιότητα του συγγραφέα μόνο', self)
        self.all_authors_checkbox.setToolTip('Αν είναι επιλεγμένο, το όνομα του συγγραφέα θα αναζητηθεί\n'
                                              'με την ιδιότητα του συγγραφέα και μόνο.\n\n'
                                              'Άν δεν είναι επιλεγμένο η αναζήτηση θα ψάξει το όνομα\n'
                                              'και σε άλλες ιδιότητες π.χ. μεταφραστής ή επιμελητής κτλ.\n')
        self.all_authors_checkbox.setChecked(c.get(KEY_GET_ALL_AUTHORS, DEFAULT_STORE_VALUES[KEY_GET_ALL_AUTHORS]))
        other_group_box_layout.addWidget(self.all_authors_checkbox, 1, 0, 1, 3)

        self.all_tags_checkbox = QCheckBox('Ληψη περισσότερων κατηγοριών βιβλίου', self)
        self.all_tags_checkbox.setToolTip('Αν είναι επιλεγμένο, θα ληφθούν και οι γενικότερες \n'
                                              'κατηγορίες βιβλίου.')
        self.all_tags_checkbox.setChecked(c.get(KEY_GET_ALL_TAGS, DEFAULT_STORE_VALUES[KEY_GET_ALL_TAGS]))
        other_group_box_layout.addWidget(self.all_tags_checkbox, 2, 0, 1, 3)		
		
		
		


    def commit(self):
        DefaultConfigWidget.commit(self)
        new_prefs = {}
        new_prefs[KEY_MAX_DOWNLOADS] = int(unicode(self.max_downloads_spin.value()))
        new_prefs[KEY_GET_ALL_AUTHORS] = self.all_authors_checkbox.checkState() == Qt.Checked
        new_prefs[KEY_GET_ALL_TAGS] = self.all_tags_checkbox.checkState() == Qt.Checked
        plugin_prefs[STORE_NAME] = new_prefs

