#/bin/sh
## Este programa toma un archivo en PDF que recibe como argumento,
## lo transforma en texto, y busca la cadena ISBN en el texto.
## El criterio de selección en el caso de múltiples hallazgos, es siempre
## tomar el último. Luego se le pasan los datos a la librería de calibre
## para que se actualice.
SAVEIFS=$IFS
IFS=$(echo -en "\n\b")

# Establece las rutas para ficheros
LISTA='/tmp/lista_dir.txt'
FTEMP='/tmp/_fichero.txt'
META='metadata.opf'

## Borra lista_dir si existe
[ -f ${LISTA} ] && rm ${LISTA};

## Busca los directorios y los escribe en un fichero temporal
find "$1" -name ${META} -exec dirname {} \; > ${LISTA}

#dir_lib=`cat ${LISTA}`

for dir_lib in `cat ${LISTA}` ; do
	echo "Directorio de búsqueda: ${dir_lib}"
	cd "${dir_lib}"

## Obtiene el ID del fichero
	ID_L=`cat ${META} | grep 'id="calibre_id"'| \
	cut -d '>' -f 2 | cut -d '<' -f 1`

	echo ID del fichero: ${ID_L}

## Revisa si ya tiene un ISBN registrado
	ISBNNUM=`cat ${META} | grep -i 'dc:identifier opf:scheme="ISBN"'| \
	cut -d '>' -f 2 | cut -d '<' -f 1`
	ISBNQ=`echo ${ISBNNUM} | tr -d '\n' | wc -m`

	echo "ISBN registrado ${ISBNNUM}"

	if [ ${ISBNQ} -lt 10 ] || [ ${ISBNQ} -gt 13 ];
	then
## Obtiene el PDF con la ruta completa
		echo 'ISBN no cumple'
		echo "ruta completa $PWD"
		PDFF=`find . -type f -name \*.pdf|head -n1`

		echo "Nombre del PDF: ${PDFF}"

# Pasa a la siguiente iteración si el fichero no es PDF
		if [ `echo ${PDFF} | wc -c` -eq 0 ];
		then
			echo "El fichero no es PDF"
			break
		fi

## Borra el fichero temporal
		[ -f ${FTEMP} ] && rm ${FTEMP};

## Convierte el PDF a texto, envía los errores a NULL
		pdfgrep -i isbn "${PDFF}" > ${FTEMP} 2> /dev/null
# Pasar todo a minúscula
		[ -f ${FTEMP} ] && \
		sed -i -e 's/\(.*\)/\L\1/' ${FTEMP}

		if [ `cat ${FTEMP} | wc -c` == 0 ];
		then 
			pdfgrep -i \
			"international standard book number" \
			"${PDFF}" > ${FTEMP} 2> /dev/null
# Pasar todo a minúscula
			sed -i -e 's/\(.*\)/\L\1/' ${FTEMP}
			sed -i -e \
			's/international standard book number/isbn/g' \
			${FTEMP} 
		fi

		if [ `cat ${FTEMP} | wc -c` == 0 ];
		then 
			pdfgrep 978 "${PDFF}" > ${FTEMP} 2> /dev/null
# Pasar todo a minúscula
			sed -i -e 's/\(.*\)/\L\1/' ${FTEMP}
			sed -i -e 's/978/isbn-13 978/g' ${FTEMP} 
		fi 

		cat ${FTEMP}

		if [ `cat ${FTEMP} | wc -c` != 0 ];
		then
			echo "entre al if"

# Soluciona el problema de varios ISBN en una sola línea
			sed -i -e 's/isbn/\nisbn/g' ${FTEMP}
			sed -i -e 's/isbn *:/isbn/g' ${FTEMP}
			sed -i -e 's/isbn *13/isbn-13/g' ${FTEMP}
			sed -i -e 's/isbn *\n/isbn /g' ${FTEMP}
			sed -i -e 's/isbn *978/isbn-13 978/g' ${FTEMP}
			sed -i -e 's/isbn *10/isbn-10/g' ${FTEMP}
			cat ${FTEMP}

# Busca primero si hay un isbn 13			
			grep "isbn-13" ${FTEMP} > ${FTEMP}.2

# Después busca si hay un isbn 10
			[ `cat ${FTEMP}.2 | wc -c` == 0 ] && \
			grep "isbn-10" ${FTEMP} > ${FTEMP}.2

# Sino busca un simple isbn
			[ `cat ${FTEMP}.2 | wc -c` == 0 ] && \
			grep "isbn" ${FTEMP} > ${FTEMP}.2

			VALOR=$(cat ${FTEMP}.2 | \
			grep -i isbn | head -n1 | \
			sed 's/isbn-13//g' |sed 's/isbn-10//g'| \
			sed 's/-//g' | sed 's/ //g' | grep -o '[0-9]\+' | \
			tr -d "\n" )
			echo ${VALOR}

			if [ ${VALOR} ];
			then

# cuenta cuantos digitos tiene
				NUM=$(echo ${VALOR} | tr -d '\n' | wc -m)
				if ! [ $NUM -lt 9 ] && ! [ $NUM -gt 13 ];
				then
					echo "ISBN encontrado es: ${VALOR}"
					V_ISBN=$(echo ${VALOR} | awk '{print $NF}')
					echo el valor de \$V_ISBN es: $V_ISBN 
					echo el valor de \${ID_L} es: ${ID_L}

					calibredb set_metadata -f \
					identifiers:isbn:$V_ISBN ${ID_L} && echo "Listo...!"

					calibredb export ${ID_L} && echo "Listo...!"
				else
						echo "ISBN encontrado es inválido"
				fi
			else
					echo "No se puede encontrar ISBN"
			fi

			[ -f ${FTEMP} ] && rm ${FTEMP};

		else
			echo "Conversion de PDF a texto fallida"
		fi

	else
			echo "Ya tiene ISBN"
	fi
	#echo "linea" $LINEA
	IFS=$SAVEIFS
	echo =====================
	echo 
#	read
done

exit 0
