#!/bin/bash
#tcss = the config shuffel script
#credits to NiLuJe for the model dance and the eips function
p_conf="bin/"
export p_conf

model_dance () {
# Do the model dance...
#
# <width>	<height>	<prefix> # <comment>
# 600		800			s	 # K2, K3, K4, K5, KT2, KT3
# 758		1024		m	 # PW1, PW2
# 824		1200		l	 # DX, DXi, DXG
# 1072		1448		xl	 # PW3, KV
source ${p_conf}/tcss.conf
kid="$(cut -c1-6 /proc/usid)"
kmodel="$(cut -c3-4 /proc/usid)"
case "${kmodel}" in
	"01" )
		devicemodel="Kindle 1"
	;;
	"02" )
		devicemodel="Kindle 2 U.S."
	;;
	"03" )
		devicemodel="Kindle 2 International"
	;;
	"04" )
		devicemodel="Kindle DX U.S."
	;;
	"05" )
		devicemodel="Kindle DX International"
	;;
	"09" )
		devicemodel="Kindle DX Graphite"
	;;
	"08" )
		devicemodel="Kindle 3 WiFi"
	;;
	"06" )
		devicemodel="Kindle 3 3G U.S."
	;;
	"0A" )
		devicemodel="Kindle 3 3G Europe"
	;;
	"0E" )
		devicemodel="Silver Kindle 4"
	;;
	"0F" )
		devicemodel="Kindle Touch 3G U.S"
	;;
	"11" )
		devicemodel="Kindle Touch WiFi"
	;;
	"10" )
		devicemodel="Kindle Touch 3G Europe"
	;;
	"12" )
		devicemodel="Kindle 5 (Unknown)"
	;;
	"23" )
		devicemodel="Black Kindle 4"
	;;
	"24" )
		devicemodel="Kindle PaperWhite WiFi"
	;;
	"1B" )
		devicemodel="Kindle PaperWhite 3G U.S."
	;;
	"20" )
		devicemodel="Kindle PaperWhite 3G Brazil"
	;;
	"1C" )
		devicemodel="Kindle PaperWhite 3G Canada"
	;;
	"1D" )
		devicemodel="Kindle PaperWhite 3G Europe"
	;;
	"1F" )
		devicemodel="Kindle PaperWhite 3G Japan"
	;;
	"D4" )
		devicemodel="Kindle PaperWhite 2 WiFi U.S & Intl"
	;;
	"5A" )
		devicemodel="Kindle PaperWhite 2 WiFi Japan"
	;;
	"D5" )
		devicemodel="Kindle PaperWhite 2 3G U.S."
	;;
	"D6" )
		devicemodel="Kindle PaperWhite 2 3G Canada"
	;;
	"D7" )
		devicemodel="Kindle PaperWhite 2 3G Europe"
	;;
	"D8" )
		devicemodel="Kindle PaperWhite 2 3G Russia"
	;;
	"F2" )
		devicemodel="Kindle PaperWhite 2 3G Japan"
	;;
	"17" )
		devicemodel="Kindle PaperWhite 2 WiFi 4GB Europe"
	;;
	"60" )
		devicemodel="Kindle PaperWhite 2 3G 4GB Europe"
	;;
	"F4" )
		devicemodel="Unknown Kindle PaperWhite 2 (0xF4)"
	;;
	"F9" )
		devicemodel="Unknown Kindle PaperWhite 2 (0xF9)"
	;;
	"62" )
		devicemodel="Kindle PaperWhite 2 3G 4GB U.S."
	;;
	"61" )
		devicemodel="Kindle PaperWhite 2 3G 4GB Brazil"
	;;
	"5F" )
		devicemodel="Kindle PaperWhite 2 3G 4GB Canada"
	;;
	"C6" )
		devicemodel="Kindle Basic"
	;;
	"DD" )
		devicemodel="Kindle Basic Australia"
	;;
	"13" )
		devicemodel="Kindle Voyage WiFi"
	;;
	"54" )
		devicemodel="Kindle Voyage 3G U.S."
	;;
	"2A" )
		devicemodel="Kindle Voyage 3G Japan"
	;;
	"4F" )
		devicemodel="Unknown Kindle Voyage (0x4F)"
	;;
	"52" )
		devicemodel="Kindle Voyage 3G Mexico"
	;;
	"53" )
		devicemodel="Kindle Voyage 3G Europe"
	;;
	* )
		# Try the new device ID scheme...
		kmodel="$(cut -c4-6 /proc/usid)"
		case "${kmodel}" in
			"0G1" )
				devicemodel="Kindle PaperWhite 3 WiFi"
			;;
			"0G2" )
				devicemodel="Kindle PaperWhite 3 3G U.S."
			;;
			"0G4" )
				devicemodel="Kindle PaperWhite 3 3G Mexico"
			;;
			"0G5" )
				devicemodel="Kindle PaperWhite 3 3G Europe"
			;;
			"0G6" )
				devicemodel="Kindle PaperWhite 3 3G Canada"
			;;
			"0G7" )
				devicemodel="Kindle PaperWhite 3 3G Japan"
			;;
			"0KB" )
				devicemodel="White Kindle PaperWhite 3 WiFi"
			;;
			"0KC" )
				devicemodel="White Kindle PaperWhite 3 3G Japan"
			;;
			"0KD" )
				devicemodel="Unknown White Kindle PaperWhite 3 (0KD)"
			;;
			"0KE" )
				devicemodel="Unknown White Kindle PaperWhite 3 (0KE)"
			;;
			"0KF" )
				devicemodel="Unknown White Kindle PaperWhite 3 (0KF)"
			;;
			"0KG" )
				devicemodel="Unknown White Kindle PaperWhite 3 (0KG)"
			;;
			"0GC" )
				devicemodel="Kindle Oasis WiFi"
			;;
			"0GD" )
				devicemodel="Kindle Oasis 3G U.S."
			;;
			"0GR" )
				devicemodel="Unknown Kindle Oasis (0GR)"
			;;
			"0GS" )
				devicemodel="Unknown Kindle Oasis (0GS)"
			;;
			"0GT" )
				devicemodel="Unknown Kindle Oasis (0GT)"
			;;
			"0GU" )
				devicemodel="Kindle Oasis 3G Europe"
			;;
			"0DU" )
				devicemodel="Unknown Kindle Basic 2 (0DU)"
			;;
			"0K9" )
				devicemodel="Kindle Basic 2"
			;;
			"0KA" )
				devicemodel="White Kindle Basic 2"
			;;
			* )
				devicemodel="Unknown"
			;;
		esac
	;;
esac

# This part and the blob part is borrowed from helper+ script thx
#
# And now that we have out data, setup what we'll need to show it...
# NOTE: Keep this in sync w/ BatteryStatus!
# We need to get the proper constants for our model...
case "${kmodel}" in
	"13" | "54" | "2A" | "4F" | "52" | "53" )
		# Voyage...
		SCREEN_X_RES=1088	
		SCREEN_Y_RES=1448
		EIPS_X_RES=16
		EIPS_Y_RES=24
		if [  ${prefix} = xl ] ; then
		echo "...prefix already set"
		else
		sed -i "5s/.*/prefix=xl/" ${p_conf}tcss.conf
		fi		
	;;
	"24" | "1B" | "1D" | "1F" | "1C" | "20" | "D4" | "5A" | "D5" | "D6" | "D7" | "D8" | "F2" | "17" | "60" | "F4" | "F9" | "62" | "61" | "5F" )
		# PaperWhite...
		SCREEN_X_RES=768	# NOTE: Yes, 768, not 758...
		SCREEN_Y_RES=1024
		EIPS_X_RES=16
		EIPS_Y_RES=24
		if [  ${prefix} = m ] ; then
		echo "...prefix already set"
		else
		sed -i "5s/.*/prefix=m/" ${p_conf}tcss.conf
		fi
	;;
	"C6" | "DD" )
		# KT2...
		SCREEN_X_RES=608
		SCREEN_Y_RES=800
		EIPS_X_RES=16
		EIPS_Y_RES=24
		if [  ${prefix} = s ] ; then
		echo "...prefix already set"
		else
		sed -i "5s/.*/prefix=s/" ${p_conf}tcss.conf
		fi
	;;
	"0F" | "11" | "10" | "12" )
		# Touch
		SCREEN_X_RES=600
		SCREEN_Y_RES=800
		EIPS_X_RES=12
		EIPS_Y_RES=20
		if [  ${prefix} = s ] ; then
		echo "...prefix already set"
		else
		sed -i "5s/.*/prefix=s/" ${p_conf}tcss.conf
		fi
	;;
	# Try the new device ID scheme... kmodel always points to our actual device code, no matter the scheme.
	"0G1" | "0G2" | "0G4" | "0G5" | "0G6" | "0G7" | "0KB" | "0KC" | "0KD" | "0KE" | "0KF" | "0KG" )
		# PW3... NOTE: Hopefully matches the KV...
		SCREEN_X_RES=1088
		SCREEN_Y_RES=1448
		EIPS_X_RES=16
		EIPS_Y_RES=24
		if [  ${prefix} = xl ] ; then
		echo "...prefix already set"
		else
		sed -i "5s/.*/prefix=xl/" ${p_conf}tcss.conf
		fi
	;;
	"0GC" | "0GD" | "0GR" | "0GS" | "0GT" | "0GU" )
		# Oasis... NOTE: Hopefully matches the KV...
		SCREEN_X_RES=1088
		SCREEN_Y_RES=1448
		EIPS_X_RES=16
		EIPS_Y_RES=24
		if [  ${prefix} = xl ] ; then
		echo "...prefix already set"
		else
		sed -i "5s/.*/prefix=xl/" ${p_conf}tcss.conf
		fi
	;;
	"0DU" | "0K9" | "0KA" )
		# KT3... NOTE: Hopefully matches the KT2...
		SCREEN_X_RES=608
		SCREEN_Y_RES=800
		EIPS_X_RES=16
		EIPS_Y_RES=24
		if [  ${prefix} = s ] ; then
		echo "...prefix already set"
		else
		sed -i "5s/.*/prefix=s/" ${p_conf}tcss.conf
		fi
	;;
	* )
		# Handle legacy devices...
		if [ -f "/etc/rc.d/functions" ] && grep "EIPS" "/etc/rc.d/functions" > /dev/null 2>&1 ; then
			. /etc/rc.d/functions
		else
			# Fallback... We shouldn't ever hit that.
			SCREEN_X_RES=600
			SCREEN_Y_RES=800
			EIPS_X_RES=12
			EIPS_Y_RES=20
			if [  ${prefix} = s ] ; then
			echo "...prefix already set"
			else
			sed -i "5s/.*/prefix=s/" ${p_conf}tcss.conf
			fi
		fi
	;;
esac
}

# re_set function to default settings
re_set () {
	echo layout=default > ${p_conf}tcss.conf
	echo tileset=small >> ${p_conf}tcss.conf
	echo bg=default >> ${p_conf}tcss.conf
	echo solveable=-s >> ${p_conf}tcss.conf
	echo prefix= >> ${p_conf}tcss.conf
	echo "...Config changes to Default"
	echo "......SUCCESSFUL!"
	echo
	}

check_conf () {
# check on config file and create if needed
if [ -e "${p_conf}tcss.conf" ]
then
	echo
	echo "...Config File exists."
	echo "......we are good to go."
	echo
else
	echo
	echo "...Config file missing!"
	echo "......Creating config file at ${p_conf}tcss.conf."
	echo
	re_set
	source ${p_conf}tcss.conf
	echo "These are your default settings."
	echo
	echo "Layout		:	${layout}"
	echo "Tileset		:	${tileset}"
	echo "Background	:	${bg}"
	echo "Solvable	:	${solveable}"
	echo "Model Name	:	${devicemodel}"
	echo "Prefix		:	${prefix}"
	echo
fi
}

# setup functions...line numbers in tcss.conf :
# layout {1} tileset {2} bg {3} solveable {4} prefix {5} extra {6}
s_all () {
	sed -i "1s/.*/layout=${1}/" ${p_conf}tcss.conf
	sed -i "2s/.*/tileset=${2}/" ${p_conf}tcss.conf
	sed -i "3s/.*/bg=${3}/" ${p_conf}tcss.conf
	sed -i "4s/.*/solveable=${4}/" ${p_conf}tcss.conf
	echo
	echo "...Changing Settings to : Layout: ${layout}, Tileset: ${tileset}, Background: ${bg}, Solveable: ${solve}"
	echo "......SUCCESSFUL!"
	echo
	}

s_layout () {
	sed -i "1s/.*/layout=${1}/" ${p_conf}tcss.conf
	}
	
s_tileset () {
	sed -i "2s/.*/tileset=${1}/" ${p_conf}tcss.conf
	echo
	echo "......Tileset changed."
	echo
	}

s_bg () {
	sed -i "3s/.*/bg=${1}/" ${p_conf}tcss.conf
	echo
	echo "......Background changed."
	echo
	}

s_solveable () {
	sed -i "4s/.*/solveable=${1}/" ${p_conf}tcss.conf
	echo
	echo "......Solveable changed."
	echo
	}

mah_jongg () {
	if [ ${#} -eq 0 ]
	then
		model_dance
		check_conf
		echo ".........Starting Game"
		echo
		source ${p_conf}tcss.conf
		/mnt/us/extensions/xmahjongg/bin/xmahjongg -l ${layout} -t ${prefix}/${tileset} --bg ${prefix}/${bg} ${solvable}
	else
		model_dance
		sed -i "1s/.*/layout=${1}/" ${p_conf}tcss.conf
		echo
		echo "......Layout changed."
		echo ".........Starting Game"
		echo
		source ${p_conf}tcss.conf
		/mnt/us/extensions/xmahjongg/bin/xmahjongg -l ${layout} -t ${prefix}/${tileset} --bg ${prefix}/${bg} ${solvable}
	fi
	}

$@
