#!/bin/sh
source bin/tcss.sh model_dance
# And now we can do the maths ;)
EIPS_MAXCHARS="$((${SCREEN_X_RES} / ${EIPS_X_RES}))"
EIPS_MAXLINES="$((${SCREEN_Y_RES} / ${EIPS_Y_RES}))"

# Adapted from libkh[5]
eips_print_bottom_centered()
{
	# We need at least two args
	if [ $# -lt 2 ] ; then
		echo "not enough arguments passed to eips_print_bottom_centered ($# while we need at least 2)"
		return
	fi

	kh_eips_string="${1}"
	kh_eips_y_shift_up="${2}"

	# Get the real string length now
	kh_eips_strlen="${#kh_eips_string}"

	# Add the right amount of left & right padding, since we're centered, and eips doesn't trigger a full refresh,
	# so we'll have to padd our string with blank spaces to make sure two consecutive messages don't run into each other
	kh_padlen="$(((${EIPS_MAXCHARS} - ${kh_eips_strlen}) / 2))"

	# Left padding...
	while [ ${#kh_eips_string} -lt $((${kh_eips_strlen} + ${kh_padlen})) ] ; do
		kh_eips_string=" ${kh_eips_string}"
	done

	# Right padding (crop to the edge of the screen)
	while [ ${#kh_eips_string} -lt ${EIPS_MAXCHARS} ] ; do
		kh_eips_string="${kh_eips_string} "
	done

	# Sleep a tiny bit to workaround the logic in the 'new' (K4+) eInk controllers that tries to bundle updates,
	# otherwise it may drop part of our messages because of other screen updates from KUAL...
	if [ ${kmodel} -eq 023 -o 00E ]
	then
		usleep 150000	# 150ms
	else
		usleep 30000	# 30ms works good with kt3 lets see if someone complaints
	fi
	
	# And finally, show our formatted message centered on the bottom of the screen (NOTE: Redirect to /dev/null to kill unavailable character & pixel not in range warning messages)
	eips 0 $((${EIPS_MAXLINES} - 3 - ${kh_eips_y_shift_up})) "${kh_eips_string}" >/dev/null
}

eips_conf()
{
	# Showtime!
	# Begin by warning if we failed to get our data...
	if [ "${device_type}" == "unknown" ] ; then
		eips_print_bottom_centered "Could not collect data" -2
	fi

	source ${p_conf}/tcss.conf
	eips_print_bottom_centered "Layout	: ${layout}" 1
	eips_print_bottom_centered "Tileset	: ${tileset}" 0
	eips_print_bottom_centered "Background	: ${bg}" -1
	eips_print_bottom_centered "Solvable	: ${solveable}" -2	
	

return 0
}

eips_credits()
{
	# Showtime!
	# Begin by warning if we failed to get our data...
	if [ "${device_type}" == "unknown" ] ; then
		eips_print_bottom_centered "Could not collect data" 2
	fi

	eips_print_bottom_centered "[HIT THE TOP BAR TO CLOSE INFO]" 24
	eips_print_bottom_centered "" 23
	eips_print_bottom_centered "CREDITS" 22
	eips_print_bottom_centered "Eddie Kohler, eddietwo@lcs.mit.edu" 21
	eips_print_bottom_centered "www.pdos.lcs.mit.edu/~eddietwo/" 20
	eips_print_bottom_centered "www.lcdf.org/~eddietwo/xmahjongg/" 19
	eips_print_bottom_centered "The xmahjongg home page." 18
	eips_print_bottom_centered "The original version." 17
	eips_print_bottom_centered "" 16
	eips_print_bottom_centered "Hanspeter and sguerrini97" 15
	eips_print_bottom_centered "Adjust and compile code for Kindle" 14
	eips_print_bottom_centered "" 13
	eips_print_bottom_centered "wodan" 12
	eips_print_bottom_centered "Adjust tilesets, adding backgrounds" 11
	eips_print_bottom_centered "and creating new Kual Menu for Kindle" 10
	eips_print_bottom_centered "" 9
	eips_print_bottom_centered "NiLuJe" 8
	eips_print_bottom_centered "Device recognition > Model Dance" 7
	eips_print_bottom_centered "Eips script for Info display" 6
	eips_print_bottom_centered "www.mobileread.com/forums/showthread.php?t=276639" 5
	eips_print_bottom_centered "" 4
	eips_print_bottom_centered "pixabay.com for public domain images" 3
	eips_print_bottom_centered "Have fun playing" 2
	

return 0
}

eips_info()
{
	# Showtime!
	# Begin by warning if we failed to get our data...
	if [ "${device_type}" == "unknown" ] ; then
		eips_print_bottom_centered "Could not collect data" 2
	fi

	
	eips_print_bottom_centered "[HIT THE TOP BAR TO CLOSE INFO]" 24
	eips_print_bottom_centered "" 23
	eips_print_bottom_centered "[Quick Play] starts your last setup." 22
	eips_print_bottom_centered "Set your favorite layout, tileset" 21
	eips_print_bottom_centered "and background" 20
	eips_print_bottom_centered "with the respective buttons." 19
	eips_print_bottom_centered "" 18
	eips_print_bottom_centered "You can reset the settings in [Misc]," 17
	eips_print_bottom_centered "as well as switching the boards" 16
	eips_print_bottom_centered "to solveable or any." 15
	eips_print_bottom_centered "" 14
	eips_print_bottom_centered "Click on [History & How to Play]," 13
	eips_print_bottom_centered "if you are not sure how to start" 12
	eips_print_bottom_centered "" 11
	eips_print_bottom_centered "All submenus have a fixed" 10
	eips_print_bottom_centered "top and a bottom bar," 9
	eips_print_bottom_centered "The [GO MAHJONGG] top bar starts" 8
	eips_print_bottom_centered "a game with the current config." 7
	eips_print_bottom_centered "" 6
	eips_print_bottom_centered "The bottom [SHOW CONFIG] bar shows" 5
	eips_print_bottom_centered "the current Settings on the fly." 4
	eips_print_bottom_centered "" 3
	eips_print_bottom_centered "All settings are saved." 2
	

return 0
}

eips_device()
{
	# Showtime!
	# Begin by warning if we failed to get our data...
	if [ "${device_type}" == "unknown" ] ; then
		eips_print_bottom_centered "Could not collect data" -2
	fi
	source ${p_conf}/tcss.conf
	eips_print_bottom_centered "" 24
	eips_print_bottom_centered "[HIT THE TOP BAR TO CLOSE INFO]" 23
	eips_print_bottom_centered "" 22
	eips_print_bottom_centered "" 21
	eips_print_bottom_centered "" 20
	eips_print_bottom_centered "" 19
	eips_print_bottom_centered "Your Model" 18
	eips_print_bottom_centered "${devicemodel}" 17
	eips_print_bottom_centered "" 16
	eips_print_bottom_centered "Kindle Serial Number" 15
	eips_print_bottom_centered "${kid}" 14
	eips_print_bottom_centered "" 13
	eips_print_bottom_centered "Screen Resolution" 12
	eips_print_bottom_centered "${SCREEN_Y_RES} x ${SCREEN_X_RES}" 11
	eips_print_bottom_centered "" 10
	eips_print_bottom_centered "EIPS Resolution " 9
	eips_print_bottom_centered "${EIPS_Y_RES} x ${EIPS_X_RES}" 8
	eips_print_bottom_centered "" 7
	eips_print_bottom_centered "Config File Location" 6
	eips_print_bottom_centered "extensions/xmahjongg/${p_conf}tcss.conf" 5
	eips_print_bottom_centered "" 4
	eips_print_bottom_centered "Folder Prefix" 3
	eips_print_bottom_centered "${prefix}" 2


return 0
}

$@
