#!/usr/bin/env python
import sys

try:
    from sigil_bs4 import BeautifulSoup
    print('Sigil bs4 imported')
except:
    from bs4 import BeautifulSoup
    print('regular bs4 imported')

def run(bk):
    print('Launcher version: ', bk.launcher_version())
    print('Python version: ', sys.version, '\n')
    
    for (id, href) in bk.text_iter():
        print("Processing: ",id, href)

        html = bk.readfile(id)
        soup = BeautifulSoup(html, 'html.parser')
    
        for tag in soup():
            for attribute in ["lang", "id", "dir", "name" "link"]:
                del tag[attribute]

        html = str(soup)
        print(html)
        bk.writefile(id, html)
    
    return 0

def main():
    print('I reached main when I should not have\n')
    return -1

if __name__ == "__main__":
    sys.exit(main())
