#!/bin/sh

if [ "$1" = "" -o "$1" = "360" ]; then

    echo
    if [ -f pb-360/epubinfo ]; then
        echo 'Remove previous build'
        rm -f pb-360/epubinfo
    fi

    mkdir -p pb-360
    cd pb-360
    cmake \
        -D CMAKE_TOOLCHAIN_FILE=../tools/toolchain-arm-pocketbook.cmake \
        -D CMAKE_BUILD_TYPE=Release \
        -D BUILD_360=1 \
        ..
    make

    cd ..
    if [ -f pb-360/epubinfo ]; then
        echo 'Strip binary'
        ../../PBSDK/bin/arm-linux-strip pb-360/epubinfo
    else
        echo 'Failed compiling binary!'
        exit
    fi
    echo -e "Done\n"

fi

if [ "$1" = "" -o "$1" = "fw2" ]; then

    if [ ! -f $HOME/PBDEV/FRSCSDK/arm-none-linux-gnueabi/sysroot/usr/lib/libinkview.1.1a.so ]; then
        echo
        echo 'Invalid SDK structure!'
        echo
        echo 'libinkview.so is in FRSCSDK/arm-none-linux-gnueabi/sysroot/usr/lib/'
        echo '  For fw2 you have to rename it to libinkview.1.1a.so'
        echo '  (a symlink is created by make.sh when needed)'
        echo
        exit
    fi

    rm -f $HOME/PBDEV/FRSCSDK/arm-none-linux-gnueabi/sysroot/usr/lib/libinkview.so
    ln -s \
        $HOME/PBDEV/FRSCSDK/arm-none-linux-gnueabi/sysroot/usr/lib/libinkview.1.1a.so \
        $HOME/PBDEV/FRSCSDK/arm-none-linux-gnueabi/sysroot/usr/lib/libinkview.so

    echo
    if [ -f pb-fw2/epubinfo ]; then
        echo 'Remove previous build'
        rm -f pb-fw2/epubinfo
    fi

    mkdir -p pb-fw2
    cd pb-fw2
    cmake \
        -D CMAKE_TOOLCHAIN_FILE=../tools/toolchain-arm-gnu-eabi-pocketbook.cmake \
        -D CMAKE_BUILD_TYPE=Release \
        -D BUILD_FW2=1 \
        ..
    make

    cd ..
    if [ -f pb-fw2/epubinfo ]; then
        echo 'Strip binary'
        ../../FRSCSDK/bin/arm-none-linux-gnueabi-strip pb-fw2/epubinfo
    else
        echo 'Failed compiling binary!'
        exit
    fi
    echo -e "Done\n"

fi

if [ "$1" = "" -o "$1" = "fw4" ]; then

    if [ ! -f $HOME/PBDEV/FRSCSDK/arm-none-linux-gnueabi/sysroot/usr/lib/libinkview.1.1a.so ]; then
        echo
        echo 'Invalid SDK structure!'
        echo
        echo 'libinkview.so is in FRSCSDK/arm-none-linux-gnueabi/sysroot/usr/lib/'
        echo '  For fw4 you have to add libinkview.pb626.fw4.4.so from a FW4 device to the lib dir'
        echo '  (a symlink is created by make.sh when needed)'
        echo
        exit
    fi

    rm -f $HOME/PBDEV/FRSCSDK/arm-none-linux-gnueabi/sysroot/usr/lib/libinkview.so
    ln -s \
        $HOME/PBDEV/FRSCSDK/arm-none-linux-gnueabi/sysroot/usr/lib/libinkview.pb626.fw4.4.so \
        $HOME/PBDEV/FRSCSDK/arm-none-linux-gnueabi/sysroot/usr/lib/libinkview.so

    echo
    if [ -f pb-fw4/epubinfo ]; then
        echo 'Remove previous build'
        rm -f pb-fw4/epubinfo
    fi

    mkdir -p pb-fw4
    cd pb-fw4
    cmake \
        -D CMAKE_TOOLCHAIN_FILE=../tools/toolchain-arm-gnu-eabi-pocketbook.cmake \
        -D CMAKE_BUILD_TYPE=Release \
        -D BUILD_FW4=1 \
        ..
    make

    cd ..
    if [ -f pb-fw4/epubinfo ]; then
        echo 'Strip binary'
        ../../FRSCSDK/bin/arm-none-linux-gnueabi-strip pb-fw4/epubinfo
    else
        echo 'Failed compiling binary!'
        exit
    fi
    echo -e "Done\n"

fi

if [ "$1" = "" -o "$1" = "fw5" ]; then

    echo
    if [ -f pb-fw5/epubinfo ]; then
        echo 'Remove previous build'
        rm -f pb-fw5/epubinfo
    fi

    mkdir -p pb-fw5
    cd pb-fw5
    cmake \
        -D CMAKE_TOOLCHAIN_FILE=../tools/toolchain-arm-obreey-linux-gnueabi-pocketbook.cmake \
        -D CMAKE_BUILD_TYPE=Release \
        -D BUILD_FW5=1 \
        ..
    make

    cd ..
    if [ -f pb-fw5/epubinfo ]; then
        echo 'Strip binary'
        ../../SDK_481/bin/arm-obreey-linux-gnueabi-strip pb-fw5/epubinfo
    else
        echo 'Failed compiling binary!'
        exit
    fi
    echo -e "Done\n"

fi

for TYPE in '360' 'fw2' 'fw4' 'fw5'; do
    if [ "$1" = "" -o "$1" = "$TYPE" ]; then
        rm -rf ../../releases/epubinfo-$TYPE/
        if [ -f pb-$TYPE/epubinfo ]; then
            mkdir -p ../../releases/epubinfo-$TYPE/images/
            cp pb-$TYPE/epubinfo ../../releases/epubinfo-$TYPE/epubinfo
            cp images/* ../../releases/epubinfo-$TYPE/images/
        fi
    fi
done
