#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals, division, absolute_import, print_function
import sys, os, locale
from subprocess import Popen, PIPE
from xml.sax.saxutils import escape

iswindows = sys.platform.startswith('win')
isosx = sys.platform.startswith('darwin')

if iswindows:
	os_encoding = locale.getpreferredencoding()
else:	
	os_encoding = 'UTF-8'
	
# simple wrapper
def csslintWrapper(*args):
    if iswindows or isosx:
        process = Popen(list(args), stdout=PIPE, stderr=PIPE, shell=True)
    else:
        process = Popen(list(args), stdout=PIPE, stderr=PIPE)
    ret = process.communicate()
    return ret

# code provided by KevinH
def generate_line_offsets(s):
    offlst = [0]
    i = s.find('\n', 0)
    while i >= 0:
        offlst.append(i)
        i = s.find('\n', i + 1)
    return offlst

# code provided by KevinH
def charoffset(line, col, offlst):
    if iswindows:
        coffset = offlst[line-1]  + 2 + (col - 1) - line
        if line == 1:
            coffset = - 1
    else:
        coffset = offlst[line-1]  + 1 + (col - 1)
    return coffset

def run(bk):
    # get a list of csslint rules to be ignored
    ignore = None
    prefs = bk.getPrefs()
    if prefs == {}:
        prefs['order-alphabetical'] = False
        bk.savePrefs(prefs)
    
    for key in prefs:
        if prefs[key] == False:
            if ignore:
                ignore += ',' + key
            else:
                ignore = key     

    # get epub temp folder
    temp_dir = bk._w.ebook_root

    # process all css files
    for (id, href) in bk.css_iter():
        css_path = os.path.join(temp_dir, 'OEBPS', href)
        css_name =  os.path.basename(css_path)

        if isosx:
        	csslint = '/usr/local/bin/csslint'
        else:		
        	csslint = 'csslint'				

        # define csslint command line parameters
        if ignore:
            args = [csslint, '--format=compact', '--ignore=' + ignore, css_path]
        else:    
            args = [csslint, '--format=compact', css_path]

        # run csslint
        result = csslintWrapper(*args)
        print(args)
        print(result)
        if str(result[1]).startswith('env: node: No such file or directory'):
        	bk.add_result('error', None, None, 'nodejs error: env: node: No such file or directory')

        if iswindows:
            # replace colon after Windows drive letter with placeholder to ensure proper parsing
            drive_letter = os.getenv("SystemDrive")    
            csslint_messages = result[0].decode(os_encoding).replace(drive_letter, 'C^').splitlines()
        else:
            csslint_messages = result[0].decode(os_encoding).splitlines()

        last_file_name = None
        
        # process csslint messages
        for csslint_message in csslint_messages:
            linenumber = None
            colnumber = None
            
            if len(csslint_message) != 0: 
                err_list = csslint_message.split(':')

                # check for colons in messages to ensure proper parsing
                if len(err_list) > 2:
                    err_list[1:len(err_list)] = [':'.join(err_list[1:len(err_list)])]

                # separate line/column numbers from error message
                if err_list[1].strip().startswith('line') and not err_list[1].strip().startswith('line undefined'):                     
                    new_err_list = err_list[1].split(',')

                    # check for commas in the message to ensure proper parsing
                    if len(new_err_list) > 3:
                        new_err_list[2:len(new_err_list)] = [','.join(new_err_list[2:len(new_err_list)])]

                    linenumber = new_err_list[0].replace(' line ', '')
                    colnumber = new_err_list[1].replace(' col ', '')
                    if not colnumber.isdigit():
                        colnumber = None
                    message = new_err_list[2].strip()
                else:
                    message = err_list[1].strip()
                
                # calculate file offsets
                if bk.launcher_version() >= 20160909 and css_name != last_file_name: 
                    text = bk.readfile(bk.basename_to_id(css_name))
                    offlst = generate_line_offsets(text)
                    last_file_name = css_name

                # convert column number to file column offset
                if bk.launcher_version() >= 20160909 and linenumber and colnumber:
                    coffset = charoffset(int(linenumber), int(colnumber), offlst)
                else:
                    coffset = -1

                # assign message type (warning, error or info)
                if message.startswith('Warning'):
                    restype = 'warning'
                elif message.startswith('Error') or message.startswith('line undefined'): 
                    restype = 'error'
                else:
                    restype = 'info'

                # convert quotes and angle brackets to HTML entities
                message = escape(message).replace('"', "&quot;")
                
                # add column and line numbers to message
                if colnumber and linenumber:
                    message = 'line ' + linenumber + ', col ' + colnumber + '. ' + message    

                # add message to validation pane
                if coffset != -1 and linenumber:
                    bk.add_extended_result(restype, escape(css_name), linenumber, coffset, message)
                else:
                    bk.add_result(restype, escape(css_name), linenumber, message)
                    
    return 0

def main():
    print ('I reached main when I should not have\n')
    return -1

if __name__ == "__main__":
    sys.exit(main())
