#!/bin/sh -e
#
# $Id: build-updates.sh 11910 2015-04-28 19:31:21Z NiLuJe $
#

HACKNAME="dummy"
PKGNAME="${HACKNAME}"
PKGVER="0.0.N"

# We need kindletool (https://github.com/NiLuJe/KindleTool) in $PATH
if (( $(kindletool version | wc -l) == 1 )) ; then
	HAS_KINDLETOOL="true"
fi

if [[ "${HAS_KINDLETOOL}" != "true" ]] ; then
	echo "You need KindleTool (https://github.com/NiLuJe/KindleTool) to build this package."
	exit 1
fi

# Pickup our common stuff... We leave it in our staging wd so it ends up in the source package.
if [[ ! -d "../../Common" ]] ; then
        echo "The tree isn't checked out in full, missing the Common directory..."
        exit 1
fi
# LibOTAUtils 5
cp -f ../../Common/lib/libotautils5 ./libotautils5


## Install
# Copy the script to our working directory, to avoid storing crappy paths in the update package
cp ../src/install.sh ./

# Build the install package
kindletool create ota2 -d kindle5 libotautils5 install.sh Update_${PKGNAME}_${PKGVER}.bin

# Remove package specific temp stuff
rm -f ./install.sh

# Move our update
mv -f *.bin ../
