#ifndef _TRANSLATIONS_H
#define _TRANSLATIONS_H

/*
 * These are extra translations not available in the system defaults.
 * To add support for a new language, create a trans_t[] array for it
 * below, and then add it to the get_new_translations() function in
 * main.cpp.
 *
 * Each message is made up of a label (e.g. "@Conf_title") and the
 * text that is shown in the program (e.g. "Pbimageviewer Configuration").
 * For new translations, leave the label the same, but change the text
 * to the new language.  For example, in what I hope is Italian:
 * { "@Conf_title", "Pbimageviewer Configurazione" },
 */

typedef struct {
	const char *label;
	const char *trans;
} trans_t;

trans_t trans_en[] = {
	{ "@Program_name", "pbimageviewer" },
	// These are for the configuration menus.
	{ "@Conf_title", "Pbimageviewer Configuration" },
	{ "@Conf_def_info", "Default settings for newly opened books:" },
	{ "@Default_zoom_hint", "How each new page fits the screen" },
	{ "@Fine_update", "FineUpdate" },
	{ "@Fine_update_hint", "Do FineUpdate after FullUpdate" },
	{ "@Show_status_bar", "Display status bar" },
	{ "@Status_bar_hint", "Show information panel at bottom of display" },
	{ "@Conf_sys_info", "System-wide settings:" },
	{ "@Unpack_tmp", "Unpack archive files in /tmp directory" },
	{ "@Unpack_tmp_hint", "Use this if you get errors unpacking in the default location" },
	{ "@Check_rar_images", "Check image files when opening RAR/CBR archive" },
	{ "@Check_rar_images_hint", "Use this to remove invalid images from list" },
	{ "@Step_percent", "Step size as percentage of screen size" },
	{ "@Step_percent_hint", "Use this to make steps smaller or larger" },
	{ "@Reset_page", "Open at beginning when archive was finished last time" },
	{ "@Reset_page_hint", "Restart archives that were closed on the last page" },
	{ "@Start_next", "Ask to open next archive at end of current one" },
	{ "@Start_next_hint", "Use this to more easily read a series" },
	{ "@Open_orient", "Starting screen orientation" },
	{ "@Open_orient_hint", "This is ignored when Automatic orientation is used" },
	{ "@Autorotate", "Automatically rotate landscape images" },
	{ "@Autorotate_hint", "This is ignored when Automatic orientation is used" },
	{ "@pbiv_log_dir", "pbiv.log location" },
	// These are for the application menus.
	{ "@Fine_updates", "Toggle fine updates" },
	{ "@Fit_default", "Fit page in portrait, fit width in landscape" },
	{ "@Fit_double", "Fit height in portrait, fit width in landscape" },
	{ "@Fit_page", "Fit page" },
	{ "@Fit_height", "Fit height" },
	{ "@Full_size", "100% scale" },
	{ "@Custom_zoom", "Custom zoom" },
	{ "@Custom_scale", "Custom zoom scale" },
	// This is for toggling the display of the status bar.
	{ "@Toggle_status_bar", "Toggle status bar" },
	// This is for cropping margins.
	{ "@Crop_margins", "Cropping margins" },
	{ "@Crop_toggle", "Toggle cropping margins" },
	{ "@Crop_margin_size", "Size of margin after cropping" },
	{ "@Crop_margin_thresh", "Threshold (in pixels) for margin detection" },
	// This is for the detection of cartoon panels.
	{ "@Panel_detection", "Cartoon panel navigation" },
	{ "@Toggle_auto_panels", "Toggle auto detection on new pages" },
	{ "@Toggle_scale_panels", "Toggle auto scaling of panels to fit screen" },
	{ "@Select_bkgd_shade", "Define colour between panels" },
	{ "@Bkgd_lgrey", "Light Gray" },
	// This is for the custom scale keyboard.
	{ "@Enter_scale", "Set zoom scale (%)" },
	{ "@Custom_offset", "Custom zoom offset" },
	// This is for the custom offset keyboard.
	{ "@Enter_offset", "Set horizontal offset (start with '0' for negative values)" },
	// This is for setting the custom layout with the pointer.
	{ "@Custom_layout", "Custom layout (with pointer)" },
	{ "@Set_scale_ptr", "Draw a horizontal line from left to right to permanently zoom in to that portion of the image, and from right to left to permanently zoom the current view out to fit the line." },
	// This is for the directory selector.
	{ "@Open_dir", "Open directory with images" },
	// This is for failed unpacking of archive file.
	{ "@Unpack_fail", "The unpacking operation failed" },
	// This is for the dialog for the next archive to open
	{ "@Open_next", "At end of current archive. Open the next one?" },
	// These are for the display parameters.
	{ "@Display_params", "Display Settings" },
	{ "@Brightness", "Brightness" },
	{ "@Contrast", "Contrast" },
	{ "@Gamma", "Gamma" },
	{ "@Depth", "Colour depth" },
	// These are for the Help dialog.
	{ "@Button_help_title", "Button actions:" },
	{ "@Help_back", "Make next step smaller (divide by 2 for each press) /\n  Disable Panel Mode for the page" },
	{ "@Help_left", "Step left / Previous page / Previous panel" },
	{ "@Help_right", "Step right / Next Page / Next panel" },
	{ "@Help_panel_left", "Detect cartoon panels from right to left" },
	{ "@Help_panel_right", "Detect cartoon panels from left to right" },
	{ "@Help_up", "Step up / Previous page / Panel above" },
	{ "@Help_down", "Step down / Next page / Panel Below" },
	{ "@Help_prev", "Step back / Previous page / Previous panel" },
	{ "@Help_next", "Step forward / Next page / Next panel" },
	{ "@Gesture_help_title", "Two-finger gestures:" },
	{ "@Two-finger_tap", "Tap" },
	{ "@Two-finger_pinch", "Pinch" },
	{ "@Two-finger_swipe", "Swipe" },
	{ "@Help_swipe", "Rotate screen toward swipe direction" },
	{ "@Help_unzoom", "Unzoom" },
	{ "@Translation_by", "" },	//Translators, put your name there.
	// These are for the About dialog.
	{ "@About", "About pbimageviewer" },
	{ NULL, NULL }
};

trans_t trans_fr[] = {
	{ "@Program_name", "pbimageviewer" },
	// These are for the configuration menus.
	{ "@Conf_title", "Configuration de Pbimageviewer" },
	{ "@Conf_def_info", "Paramètres par défaut pour les nouveaux livres :" },
	{ "@Default_zoom_hint", "Comment adapter les nouvelles pages à l'écran" },
	{ "@Fine_update", "FineUpdate" },
	{ "@Fine_update_hint", "Faire une FineUpdate après une FullUpdate" },
	{ "@Show_status_bar", "Afficher la barre d'état" },
	{ "@Status_bar_hint", "Afficher le panneau d'information en bas de l'écran" },
	{ "@Conf_sys_info", "Paramètres généraux:" },
	{ "@Unpack_tmp", "Décompresser les archives dans /tmp" },
	{ "@Unpack_tmp_hint", "À utiliser en cas d'erreur avec le répertoire par défaut" },
	{ "@Check_rar_images", "Vérifier les images à l'ouverture d'une archive RAR/CBR" },
	{ "@Check_rar_images_hint", "Utilisez ceci pour enlever les images invalides de la liste" },
	{ "@Step_percent", "Taille du pas en pourcentage de la taille de l'écran" },
	{ "@Step_percent_hint", "Utiliser ceci pour changer la taille du pas" },
	{ "@Reset_page", "Réouvrir l'archive au début quand elle avait été finie" },
	{ "@Reset_page_hint", "Réinitialiser les archives qui ont été fermées à la dernière page." },
	{ "@Start_next", "Demander avant d'ouvrir la prochaine archive à la fin de celle en cours" },
	{ "@Start_next_hint", "Utilisez ceci pour lire plus facilement une série." },
	{ "@Open_orient", "Orientation initiale de l'écran" },
	{ "@Open_orient_hint", "Ce paramètre est ignoré quand l'orientation automatique de l'écran est utilisée." },
	{ "@Autorotate", "Détection automatique de l'orientation des images" },
	{ "@Autorotate_hint", "Ceci est ignoré quand la détection automatique est utilisée." },
	{ "@pbiv_log_dir", "emplacement de pbiv.log" },
	// These are for the application menus.
	{ "@Fine_updates", "FineUpdate" },
	{ "@Fit_default", "Adapter à la page en mode portrait et à la largeur en mode paysage" },
	{ "@Fit_double", "Adapter à la hauteur en mode portrait et à la largeur en mode paysage" },
	{ "@Fit_page", "Adapter à la page" },
	{ "@Fit_height", "Adapter à la hauteur" },
	{ "@Full_size", "Échelle de 100%" },
	{ "@Custom_zoom", "Zoom par défaut" },
	{ "@Custom_scale", "Échelle par défaut" },
	// This is for toggling the display of the status bar.
	{ "@Toggle_status_bar", "Barre de statut" },
	// This is for cropping margins.
	{ "@Crop_margins", "Rogner les marges" },
	{ "@Crop_toggle", "Rogner les marges" },
	{ "@Crop_margin_size", "Tailles des marges après rognage" },
	{ "@Crop_margin_thresh", "Seuil (en pixels) pour la détection des marges" },
	// This is for the detection of cartoon panels.
	{ "@Panel_detection", "Navigation par cases" },
	{ "@Toggle_auto_panels", "Auto-détection pour les nouvelles pages" },
	{ "@Toggle_scale_panels", "Mise à l'échelle automatique des cases pour remplir l'écran" },
	{ "@Select_bkgd_shade", "Couleur entre deux pages" },
	{ "@Bkgd_lgrey", "Gris clair" },
	// This is for the custom scale keyboard.
	{ "@Enter_scale", "Définir l'échelle  (%)" },
	{ "@Custom_offset", "Décalage du zoom" },
	// This is for the custom offset keyboard.
	{ "@Enter_offset", "Décalage horizontal (commencer par '0' pour une valeur négative) " },
	// This is for setting the custom layout with the pointer.
	{ "@Custom_layout", "Disposition par défaut (avec stylet)" },
	{ "@Set_scale_ptr", "Tracer une ligne horizontale de la gauche vers la droite pour zoomer de manière permanente sur cette partie de l'image, de la droite vers la gauche pour dézoomer de manière permanente." },
	// This is for the directory selector.
	{ "@Open_dir", "Ouvrir un répertoire d'images" },
	// This is for failed unpacking of archive file..
	{ "@Unpack_fail", "La décompression de l'archive a échoué." },
	// This is for the dialog for the next archive to open
	{ "@Open_next", "Ouvrir la prochaine archive après celle en cours ?" },
	// These are for the display parameters.
	{ "@Display_params", "Paramètres d'affichage" },
	{ "@Brightness", "Luminosité" },
	{ "@Contrast", "Contraste" },
	{ "@Gamma", "Gamma" },
	{ "@Depth", "Profondeur des couleurs" },
	// These are for the Help dialog.
	{ "@Button_help_title", "Configuration des boutons :" },
	{ "@Help_back", "Diminuer le pas suivante (divise par 2 à chaque pression) /\n Désactiver le mode cases pour la page." },
	{ "@Help_left", "Aller à gauche / Page précédente / Case précédente" },
	{ "@Help_right", "Aller à droite / Page suivante / Case suivante" },
	{ "@Help_panel_left", "Détecter les cases de droite à gauche" },
	{ "@Help_panel_right", "Détecter les cases de gauche à droite" },
	{ "@Help_up", "Décaler vers le haut / Page précedente / Case du dessus" },
	{ "@Help_down", "Décaler vers le bas / Page suivante / Case du dessous" },
	{ "@Help_prev", "Revenir / Page précédente / Case précédente" },
	{ "@Help_next", "Avancer / Page suivante / Case suivante" },
	{ "@Gesture_help_title", "Mouvements avec deux doigts :" },
	{ "@Two-finger_tap", "Taper" },
	{ "@Two-finger_pinch", "Pincer" },
	{ "@Two-finger_swipe", "Glisser le doigt" },
	{ "@Help_swipe", "Tourner l'écran dans la direction glissée" },
	{ "@Help_unzoom", "Dézoomer" },
	{ "@Translation_by", "Pascal V." },	//Translators, put your name there.
	// These are for the About dialog.
	{ "@About", "À propos de Pbimageviewer" },
	{ NULL, NULL }
};

trans_t trans_pt[] = {
	{ "@Program_name", "pbimageviewer" },
	// These are for the configuration menus.
	{ "@Conf_title", "Configuração do Pbimageviewer" },
	{ "@Conf_def_info", "Paramêtros para novos livros:" },
	{ "@Default_zoom_hint", "Como cada pagina é adaptada na tela" },
	{ "@Fine_update", "FineUpdate" },
	{ "@Fine_update_hint", "Fazer uma FineUpdate apos de uma FullUpdate" },
	{ "@Show_status_bar", "Exibir a barra de estatuto" },
	{ "@Status_bar_hint", "Exibir o pannel de informação no baixo da tela" },
	{ "@Conf_sys_info", "Paramêtros globais:" },
	{ "@Unpack_tmp", "Decompressão das arquivas no repertorio /tmp" },
	{ "@Unpack_tmp_hint", "Utilisar isso se tem problemas com o repertorio normal" },
	{ "@Check_rar_images", "Verificar as imagems na abertura dos arquivos CBR/RAR" },
	{ "@Check_rar_images_hint", "Use isso para retirar as imagems invalidas da lista" },
	{ "@Step_percent", "Tamanho do passo em percentagem do tamanho da tela" },
	{ "@Step_percent_hint", "Use isso para modificar o tamanho do passo" },
	{ "@Reset_page", "Abrir o proximo arquivo na primeira pagina quando ele estava acabado?" },
	{ "@Reset_page_hint", "Reinitialisar arquivos que foram fechados na ultima pagina." },
	{ "@Start_next", "Perguntar antes de abrir o proximo arquivo" },
	{ "@Start_next_hint", "Usar isto para ler mais facilmente séries" },
	{ "@Open_orient", "Orientação da tela no inicio" },
	{ "@Open_orient_hint", "Esse parametro é ignorado quando orientação Automatica esta em uso." },
	{ "@Autorotate", "Déteção automatica da orientação das imagens" },
	{ "@Autorotate_hint", "Ignorado quando a deteção automatica está utilisada." },
	{ "@pbiv_log_dir", "localização do pbiv.log" },
	// These are for the application menus.
	{ "@Fine_updates", "Fazer ou não Fine updates" },
	{ "@Fit_default", "Adaptar pra pagina em retrato et adaptar na larguro em paisagem" },
	{ "@Fit_double", "Adaptar pra altura em retrato et adaptar na larguro em paisagem" },
	{ "@Fit_page", "Adaptar pra pagina" },
	{ "@Fit_height", "Adaptar pra altura" },
	{ "@Full_size", "100% escala" },
	{ "@Custom_zoom", "Padrão de Zoom" },
	{ "@Custom_scale", "Padrão de escala de zoom" },
	// This is for toggling the display of the status bar.
	{ "@Toggle_status_bar", "Exibir ou não a barra de estatuto" },
	// This is for cropping margins.
	{ "@Crop_margins", "Cortar margens" },
	{ "@Crop_toggle", "Cortar ou não as margens" },
	{ "@Crop_margin_size", "Tamanho das margens apos de ser cortadas" },
	{ "@Crop_margin_thresh", "Limiar (em pixels) para deteção das margens" },
	// This is for the detection of cartoon panels.
	{ "@Panel_detection", "Navigação por quadrinhos" },
	{ "@Toggle_auto_panels", "Detectar ou não nas novas paginas" },
	{ "@Toggle_scale_panels", "Adaptar ou não os quadrinhos pra tela" },
	{ "@Select_bkgd_shade", "Definir a color entre os quadrinhos" },
	{ "@Bkgd_lgrey", "Cinza claro" },
	// This is for the custom scale keyboard.
	{ "@Enter_scale", "Definir a escala de zoom  (%)" },
	{ "@Custom_offset", "Padrão de passo de zoom" },
	// This is for the custom offset keyboard.
	{ "@Enter_offset", "Definir o passo horizontal (começar com '0' para valores negativas) " },
	// This is for setting the custom layout with the pointer.
	{ "@Custom_layout", "Padrão de comportamento (Com estilete)" },
	{ "@Set_scale_ptr", "Desenhar uma linha da esquerda pra direita pra permanentemente zoomar nesta porção da imagem. Desenhar uma ligna da direita pra esquerda pra dezoomar da linha." },
	// This is for the directory selector.
	{ "@Open_dir", "Abrir um repertorio de imagems" },
	// This is for failed unpacking of archive file.
	{ "@Unpack_fail", "A decompressão falhou" },
	// This is for the dialog for the next archive to open
	{ "@Open_next", "Abrir o proximo arquivo após do arquivo corrente?" },
	// These are for the display parameters.
	{ "@Display_params", "Paramêtros da tela" },
	{ "@Brightness", "Luminosidade" },
	{ "@Contrast", "Contraste" },
	{ "@Gamma", "Gamma" },
	{ "@Depth", "Profundidade de cor" },
	// These are for the Help dialog.
	{ "@Button_help_title", "Ações dos botões:" },
	{ "@Help_back", "Reduzir o proximo passo (dividir por 2 a cada pressão) /\n  Desativar a detessão de quadrihnos para a proxima pagina" },
	{ "@Help_left", "Ir a esquerda / Pagina anterior / Quadrinho anterior" },
	{ "@Help_right", "Ir a direita / Proxima pagina / Proximo quadrinho" },
	{ "@Help_panel_left", "Deteção de quadrinhos da direita a esquerda" },
	{ "@Help_panel_right", "Deteção de quadrinhos da esquerda a direita" },
	{ "@Help_up", "Passo pro alto / Pagina anterior / Quadrihno ao alto" },
	{ "@Help_down", "Passo pro baixo / Proxima pagina / Quadrinho ao baixo" },
	{ "@Help_prev", "Voltar / Pagina anterior / Quadrinho anterior" },
	{ "@Help_next", "Para frente / Proxima pagina / Proximo quadrinho" },
	{ "@Gesture_help_title", "Movimentos com dois dedos :" },
	{ "@Two-finger_tap", "Tap" },
	{ "@Two-finger_pinch", "Pinch" },
	{ "@Two-finger_swipe", "Swipe" },
	{ "@Help_swipe", "Gire a tela na direção do swipe" },
	{ "@Help_unzoom", "Zoom out" },
	{ "@Translation_by", "Pascal V." },	//Translators, put your name there.
	// These are for the About dialog.
	{ "@About", "Sobre Pbimageviewer" },
	{ NULL, NULL }
};

trans_t trans_de[] = {
	{ "@Program_name", "pbimageviewer" },
	// These are for the configuration menus.
	{ "@Conf_title", "Pbimageviewer Konfiguration" },
	{ "@Conf_def_info", "Standardeinstellungen:" },
	{ "@Default_zoom_hint", "Beschreibt auf welchen Teil einer Seite standardmäßig eingezoomt wird" },
	{ "@Fine_update", "Verbessertes Seitenupdate" },
	{ "@Fine_update_hint", "Auf alten Geräten wird dadurch die Anzeige verbessert" },
	{ "@Show_status_bar", "Statusleiste anzeigen" },
	{ "@Status_bar_hint", "Wird am unteren Bildschirmrand eingeblendet" },
	{ "@Conf_sys_info", "Weitere Einstellungen:" },
	{ "@Unpack_tmp", "Bücher zuvor nach /tmp entpacken" },
	{ "@Unpack_tmp_hint", "Kann bei Anzeigeproblemen helfen" },
	{ "@Check_rar_images", "Bilder beim Öffnen von RAR/CBR-Archiven prüfen" },
	{ "@Check_rar_images_hint", "Dateien, die keine Bilder sind, aus der Liste entfernen" },
	{ "@Step_percent", "Schrittgröße in Prozent der Bildschirmgröße" },
	{ "@Step_percent_hint", "Größe der Zoomschritte anpassen" },
	{ "@Reset_page", "Lesezeichen löschen sobald Buch ausgelesen wurde" },
	{ "@Reset_page_hint", "Das Buch wird auf Seite 1 geöffnet, wenn es beim letzten Mal augelesen wurde" },
	{ "@Start_next", "Mit nächstem Buch fortfahren" },
	{ "@Start_next_hint", "Nachdem ein Buch ausgelesen ist, wird das nächste nach Abfrage geöffnet" },
	{ "@Open_orient", "Standardausrichtung" },
	{ "@Open_orient_hint", "Wird bei automatischer Ausrichtung ignoriert." },
	{ "@Autorotate", "Bilder im Querformat automatisch drehen" },
	{ "@Autorotate_hint", "Wird nicht bei aktiver automatischer Drehung benutzt" },
	{ "@pbiv_log_dir", "Verzeichnis für pbiv.log" },
	// These are for the application menus.
	{ "@Fine_updates", "Verbessertes Seitenupdate ein/aus" },
	{ "@Fit_default", "An Seite/Breite anpassen (Hochformat/Querformat)" },
	{ "@Fit_double", "An Höhe/Breite anpassen (Hochformat/Querformat)" },
	{ "@Fit_page", "An Seite anpassen" },
	{ "@Fit_height", "An Höhe anpassen" },
	{ "@Full_size", "Originalgröße (1:1)" },
	{ "@Custom_zoom", "Benutzerdefiniert" },
	{ "@Custom_scale", "Zoom - Methode 1" },
	// This is for toggling the display of the status bar.
	{ "@Toggle_status_bar", "Statusleiste ein/ausblenden" },
	// This is for cropping margins.
	{ "@Crop_margins", "Ränder beschneiden" },
	{ "@Crop_toggle", "Ränder beschneiden ein/aus" },
	{ "@Crop_margin_size", "Randgröße nach Beschneiden" },
	{ "@Crop_margin_thresh", "Schwelle (in Pixel) für Randerkennung" },
	// This is for the detection of cartoon panels.
	{ "@Panel_detection", "Panelerkennung" },
	{ "@Toggle_auto_panels", "Panelerkennung ein/aus" },
	{ "@Toggle_scale_panels", "Autozoom auf Panel ein/aus" },
	{ "@Select_bkgd_shade", "Farbe zwischen den Panels" },
	{ "@Bkgd_lgrey", "Hellgrau" },
	// This is for the custom scale keyboard.
	{ "@Enter_scale", "Zoom in % eingeben" },
	{ "@Custom_offset", "Seite horizontal verschieben" },
	// This is for the custom offset keyboard.
	//{ "@Enter_offset", "0 davor steht für Minus" },
	{ "@Enter_offset", "Horizontale Verschiebung eingeben (Fuehrende Null fuer negativen Wert" },
	// This is for setting the custom layout with the pointer.
	{ "@Custom_layout", "Freihand zoomen" },
	{ "@Set_scale_ptr", "Zeichne eine horizontale Linie, um in den entsprechenden Bereich des Bildes zu zoomen, und von rechts nach links um den aktuellen Bereich auf die Größe der Linie heraus zu zoomen." },
	// This is for the directory selector.
	{ "@Open_dir", "Bilderverzeichnis öffnen" },
	// This is for failed unpacking of archive file.
	{ "@Unpack_fail", "Fehler beim Entpacken" },
	// This is for the dialog for the next archive to open
	{ "@Open_next", "Buchende erreicht, nächstes öffnen?" },
	// These are for the display parameters.
	{ "@Display_params", "Bildschirmeinstellungen" },
	{ "@Brightness", "Helligkeit" },
	{ "@Contrast", "Kontrast" },
	{ "@Gamma", "Gamma" },
	{ "@Depth", "Farbtiefe" },
	// These are for the Help dialog.
	{ "@Button_help_title", "Tastenbelegung:" },
	{ "@Help_back", "Nächsten Schritt kleiner machen (Jeder Knopfdruck teilt durch 2) /\n  Panelmodus für die Seite deaktivieren" },
	{ "@Help_left", "Schritt nach links / Vorherige Seite / Vorheriges Panel" },
	{ "@Help_right", "Schritt nach rechts / Nächste Seite / Nächstes Panel" },
	{ "@Help_panel_left", "Panels von rechts nach links erkennen" },
	{ "@Help_panel_right", "Panels von links nach rechts erkennen" },
	{ "@Help_up", "Nach oben - Seite zurück - Panel rauf" },
	{ "@Help_down", "Nach unten - Seite vor - Panel runter" },
	{ "@Help_prev", "Schritt zurück / Vorherige Seite / Vorheriges Panel" },
	{ "@Help_next", "Schritt vor / Nächste Seite / Nächstes Panel" },
	{ "@Gesture_help_title", "Zwei-Finger Gesten:" },
	{ "@Two-finger_tap", "Tippen" },
	{ "@Two-finger_pinch", "Pinch" },
	{ "@Two-finger_swipe", "Wischen" },
	{ "@Help_swipe", "Seite in Wisch-Richtung drehen" },
	{ "@Help_unzoom", "Manuellen Zoom zurücksetzen" },
	{ "@Translation_by", "seiichiro0185, runiterium" },	//Translators, put your name there.
	// These are for the About dialog.
	{ "@About", "Über pbimageviewer" },
	{ NULL, NULL }
};

trans_t trans_nl[] = {
	{ "@Program_name", "pbimageviewer" },
	// These are for the configuration menus.
	{ "@Conf_title", "Pbimageviewer configuratie" },
	{ "@Conf_def_info", "Standaardinstellingen voor nieuw geopende boeken:" },
	{ "@Default_zoom_hint", "Standaardzoom, staand: pagina aanpassen aan scherm, liggend: aanpassen aan breedte" },
	{ "@Fine_update", "Fijnverversing" },
	{ "@Fine_update_hint", "Nauwkeurige verversing na het verversen van het volledige scherm" },
	{ "@Show_status_bar", "Statusbalk tonen" },
	{ "@Status_bar_hint", "Weergave-instelling van de statusbalk onderaan het scherm" },
	{ "@Conf_sys_info", "Overige instellingen:" },
	{ "@Unpack_tmp", "Archiefbestanden uitpakken naar de /tmp-map" },
	{ "@Unpack_tmp_hint", "Wijzig deze instelling als uitpakken naar de standaardlocatie problemen geeft" },
	{ "@Check_rar_images", "Afbeeldingsbestanden controleren bij openen RAR/CBR-archieven" },
	{ "@Check_rar_images_hint", "Ongeldige afbeeldingsbestanden worden genegeerd bij RAR/CBR-archieven" },
	{ "@Step_percent", "Schuifstapgrootte (percentage van het scherm)" },
	{ "@Step_percent_hint", "Met kleinere waarden kan de pagina nauwkeuriger worden verschoven" },
	{ "@Reset_page", "Met 1e pagina starten wanneer einde was bereikt" },
	{ "@Reset_page_hint", "Bij openen met beginpagina starten wanneer het archief op de laatste pagina was afgesloten" },
	{ "@Start_next", "Vraag of volgende archief geopend moet worden" },
	{ "@Start_next_hint", "Bij series kan er bij het einde van een deel gemakkelijker worden gesprongen naar het volgende deel" },
	{ "@Open_orient", "Schermoriëntatie bij starten" },
	{ "@Open_orient_hint", "Instelling wordt genegeerd als 'Automatische schermoriëntatie' is ingesteld" },
	{ "@Autorotate", "Verticale afbeeldingen automatisch roteren" },
	{ "@Autorotate_hint", "Instelling wordt genegeerd als 'automatische schermrotatie' is ingesteld" },
	{ "@pbiv_log_dir", "Locatie pbiv.log" },
	// These are for the application menus.
	{ "@Fine_updates", "Fijnverversing aan/uit" },
	{ "@Fit_default", "Standaard" },
	{ "@Fit_double", "Staand: Aanpassen aan hoogte/Liggend: Breedte aanpassen" },
	{ "@Fit_page", "Aanpassen aan scherm" },
	{ "@Fit_height", "Aanpassen aan hoogte" },
	{ "@Full_size", "Originele grootte (1:1)" },
	{ "@Custom_zoom", "Aangepaste zoom" },
	{ "@Custom_scale", "Zoomschaal wijzigen" },
	// This is for toggling the display of the status bar.
	{ "@Toggle_status_bar", "Statusbalk aan/uit" },
	// This is for cropping margins.
	{ "@Crop_margins", "Minimale marges" },
	{ "@Crop_toggle", "Minimale marges aan/uit" },
	{ "@Crop_margin_size", "Margegrootte na aanpassing" },
	{ "@Crop_margin_thresh", "Grenswaarde (in beeldpunten) bij detecteren marges" },
	// This is for the detection of cartoon panels.
	{ "@Panel_detection", "Stripalbumherkenning" },
	{ "@Toggle_auto_panels", "Herkenning bij bladeren aan/uit" },
	{ "@Toggle_scale_panels", "Afb. aanpassen aan scherm aan/uit" },
	{ "@Select_bkgd_shade", "Achtergronddetectiekleur" },
	{ "@Bkgd_lgrey", "Lichtgrijs" },
	// This is for the custom scale keyboard.
	{ "@Enter_scale", "Voer vergrotingsschaal (%) in" },
	{ "@Custom_offset", "Verschuiving wijzigen" },
	// This is for the custom offset keyboard.
	{ "@Enter_offset", "Voer horizontale verschuiving in (begin met '0' voor negatieve waarden) " },
	// This is for setting the custom layout with the pointer.
	{ "@Custom_layout", "Via scherm wijzigen" },
	{ "@Set_scale_ptr", "Trek een horizontale lijn van links naar rechts om het gedeelte in te zoomen, en van rechts naar links om de pagina uit te zoomen tot de grootte van de lijn." },
	// This is for the directory selector.
	{ "@Open_dir", "Map met afbeeldingen openen" },
	// This is for failed unpacking of archive file.
	{ "@Unpack_fail", "De uitpakoperatie is mislukt" },
	// This is for the dialog for the next archive to open
	{ "@Open_next", "Einde huidig archief bereikt. De volgende openen?" },
	// These are for the display parameters.
	{ "@Display_params", "Weergave-instellingen" },
	{ "@Brightness", "Helderheid" },
	{ "@Contrast", "Contrast" },
	{ "@Gamma", "Gamma" },
	{ "@Depth", "Kleurendiepte" },
	// These are for the Help dialog.
	{ "@Button_help_title", "Knopacties:" },
	{ "@Help_back", "Schuifstap kleiner (elk toetsaanslag: stapgrootte/2) /\n Stripalbumherkenning op huidige pagina uitschakelen" },
	{ "@Help_left", "Schuif naar links / Vorige pag. / Vorige stripafb." },
	{ "@Help_right", "Schuif naar rechts / Volgende pag. / Volgende stripafb." },
	{ "@Help_panel_left", "Stripalbumherkenning van rechts naar links" },
	{ "@Help_panel_right", "Stripalbumherkenning van links naar rechts" },
	{ "@Help_up", "Schuif naar boven / Vorige pag. / Naar stripafb. erboven" },
	{ "@Help_down", "Schuif naar onder / Volgende pag. / Naar stripafb. eronder" },
	{ "@Help_prev", "Stap achteruit / Vorige pag. / Vorige stripafb." },
	{ "@Help_next", "Stap vooruit / Volgende pag. / Volgende stripafb." },
	{ "@Gesture_help_title", "Tweevingerbediening:" },
	{ "@Two-finger_tap", "Tikken" },
	{ "@Two-finger_pinch", "Pinchen (samenknijpende beweging)" },
	{ "@Two-finger_swipe", "Vegen" },
	{ "@Help_swipe", "Scherm roteren in de veegrichting." },
	{ "@Help_unzoom", "Zoom verlaten" },
	{ "@Translation_by", "dtanis" },	//Translators, put your name there.
	// These are for the About dialog.
	{ "@About", "Pbimageviewer-informatie" },
	{ NULL, NULL }
};

trans_t trans_ja[] = {
	{ "@Program_name", "ピビイメージビューア" },
	// These are for the configuration menus.
	{ "@Conf_title", "ピビイメージビューア設定" },
	{ "@Conf_def_info", "新しく開いた本のデフォルト設定:" },
	{ "@Default_zoom_hint", "How each new page fits the screen" },
	{ "@Fine_update", "ファイン更新 " },
	{ "@Fine_update_hint", "Do FineUpdate after FullUpdate" },
	{ "@Show_status_bar", "ステータスバーを表示" },
	{ "@Status_bar_hint", "Show information panel at bottom of display" },
	{ "@Conf_sys_info", "その他の設定:" },
	{ "@Unpack_tmp", "Unpack archive files in /tmp directory" },
	{ "@Unpack_tmp_hint", "Use this if you get errors unpacking in the default location" },
	{ "@Check_rar_images", "RAR/CBRアーカイブを開くときに画像を確認" },
	{ "@Check_rar_images_hint", "リストから不正な画像を削除" },
	{ "@Step_percent", "Step size as percentage of screen size" },
	{ "@Step_percent_hint", "Use this to make steps smaller or larger" },
	{ "@Reset_page", "Open at beginning when archive was finished last time" },
	{ "@Reset_page_hint", "Restart archives that were closed on the last page" },
	{ "@Start_next", "Ask to open next archive at end of current one" },
	{ "@Start_next_hint", "Use this to more easily read a series" },
	{ "@Open_orient", "初期画面の向き" },
	{ "@Open_orient_hint", "This is ignored when Automatic orientation is used" },
	{ "@Autorotate", "自動的に横向きの画像を回転する" },
	{ "@Autorotate_hint", "自動向きが使用されているときには無視されます" },
	{ "@pbiv_log_dir", "pbiv.log 場所" },
	// These are for the application menus.
	{ "@Fine_updates", "ファイン更新の切り替　 え"},
	{ "@Fit_default", "縦: ページに合わせる、横: 幅に合わせる" },
	{ "@Fit_double", "縦: 高さに合わせる、横: 幅に合わせる" },
	{ "@Fit_page", "ページに合わせる" },
	{ "@Fit_height", "高さに合わせる" },
	{ "@Full_size", "元のサイズ(100%)" },
	{ "@Custom_zoom", "カスタムズーム" },
	{ "@Custom_scale", "ズーム倍率" },
	// This is for toggling the display of the status bar.
	{ "@Toggle_status_bar", "ステータスバーを表示/非表示に" },
	// This is for cropping margins.
	{ "@Crop_margins", "余白を除去" },
	{ "@Crop_toggle", "余白を除去に切り替え" },
	{ "@Crop_margin_size", "余白のサイズ切断後" },
	{ "@Crop_margin_thresh", "Threshold (in pixels) for margin detection" },
	// This is for the detection of cartoon panels.
	{ "@Panel_detection", "コマの漫画ナビゲーション" },
	{ "@Toggle_auto_panels", "Toggle auto detection on new pages" },
	{ "@Toggle_scale_panels", "Toggle auto scaling of panels to fit screen" },
	{ "@Select_bkgd_shade", "Define colour between panels" },
	{ "@Bkgd_lgrey", "ライトグレー" },
	// This is for the custom scale keyboard.
	{ "@Enter_scale", "ズーム倍率を設定する (%)" },
	{ "@Custom_offset", "ズームオフセット" },
	// This is for the custom offset keyboard.
	{ "@Enter_offset", "水平方向のオフセットを設定する (負の値は、先行ゼロから始まる) " },
	// This is for setting the custom layout with the pointer.
	{ "@Custom_layout", "ポインタ付ズーム" },
	{ "@Set_scale_ptr", "Draw a horizontal line from left to right to permanently zoom in to that portion of the image, and from right to left to permanently zoom the current view out to fit the line." },
	// This is for the directory selector.
	{ "@Open_dir", "写真のディレクトリを開く" },
	// This is for failed unpacking of archive file.
	{ "@Unpack_fail", "解凍操作は失敗しました" },
	// This is for the dialog for the next archive to open
	{ "@Open_next", "現在のアーカイブは終了しました。次のアーカイブを開きますか" },
	// These are for the display parameters.
	{ "@Display_params", "表示設定" },
	{ "@Brightness", "明るさ" },
	{ "@Contrast", "コントラスト" },
	{ "@Gamma", "ガンマ" },
	{ "@Depth", "色深度" },
	// These are for the Help dialog.
	{ "@Button_help_title", "ボタンアクション:" },
	{ "@Help_back", "動きを小さくする (ボタン押すごとに2で割る) /\n  ページのためのコマの漫画のモードを無効にする" },
	{ "@Help_left", "ステップ左、前のページ、前のコマ" },
	{ "@Help_right", "ステップ右、次のページ、次のコマ" },
	{ "@Help_panel_left", "右から左に漫画コマを検出" },
	{ "@Help_panel_right", "左から右に漫画コマを検出" },
	{ "@Help_up", "上に移動、前のページ、上のコマに切り替　 え" },
	{ "@Help_down", "下に移動、次のページ、下のコマに切り替　 え" },
	{ "@Help_prev", "ステップ戻る、前のページ、前のコマ" },
	{ "@Help_next", "ステップ進む、次のページ、次のコマ" },
	{ "@Gesture_help_title", "2本指ジェスチャ:" },
	{ "@Two-finger_tap", "2本指タップ" },
	{ "@Two-finger_pinch", "2本指ピンチ" },
	{ "@Two-finger_swipe", "2本指スワイプ" },
	{ "@Help_swipe", "スワイプの方向に向かって画面を回転" },
	{ "@Help_unzoom", "ズームを解除" },
	{ "@Translation_by", "ディック・タニス" },	//Translators, put your name there.
	// These are for the About dialog.
	{ "@About", "ピビイメージビューアについて" },
	{ NULL, NULL }
};

trans_t trans_hu[] = {
	{ "@Program_name", "pbimageviewer" },
	// These are for the configuration menus.
	{ "@Conf_title", "Pbimageviewer konfiguráció" },
	{ "@Conf_def_info", "Az újonnan megnyitott könyvek alapértelmezett beállításai:" },
	{ "@Default_zoom_hint", "Hogyan tölti ki az új oldal a képernyőt" },
	{ "@Fine_update", "Jó minőségű frissítés" },
	{ "@Fine_update_hint", "Jó minőségű frissítés lapozáskor" },
	{ "@Show_status_bar", "Állapotsáv megjelenítése" },
	{ "@Status_bar_hint", "Információs panel megjelenítése a képernyő alján" },
	{ "@Conf_sys_info", "Az egész rendszerre kiterjedő beállítások:" },
	{ "@Unpack_tmp", "Archívumok kibontása a /tmp mappába" },
	{ "@Unpack_tmp_hint", "Használd ezt, ha az alapértelmezett helyre történő kibontáskor hiba történik" },
	{ "@Check_rar_images", "Ellenőrizze a képeket RAR/CBR archívum megnyitásakor" },
	{ "@Check_rar_images_hint", "Használd ezt, hogy eltávolítsd az érvénytelen képeket a listából" },
	{ "@Step_percent", "Lépés mérete, a képernyő %-ában megadva" },
	{ "@Step_percent_hint", "Ezzel állíthatod be az oldalon történő lépések nagyságát" },
	{ "@Reset_page", "Az első oldal megnyitása, ha korábban az archívum végére értél" },
	{ "@Reset_page_hint", "Az utolsó oldalon bezárt archívumok újrakezdése" },
	{ "@Start_next", "Kérdezzen rá a következő archívum megnyitására a jelenlegi végén" },
	{ "@Start_next_hint", "Ennek használatával könnyebben olvashatsz el egy sorozatot" },
	{ "@Open_orient", "Alapértelmezett képernyő orientáció" },
	{ "@Open_orient_hint", "Nincs figyelembe véve, ha az automatikus orientáció be van kapcsolva" },
	{ "@Autorotate", "Automatically rotate landscape images" },
	{ "@Autorotate_hint", "This is ignored when Automatic orientation is used" },
	{ "@pbiv_log_dir", "pbiv.log helye" },
	// These are for the application menus.
	{ "@Fine_updates", "Jó minőségű frissítések BE/KI" },
	{ "@Fit_default", "Képernyőhöz igazítás álló módban, szélességhez igazítás fekvő módban" },
	{ "@Fit_double", "Magassághoz igazítás álló módban, szélességhez igazítás fekvő módban" },
	{ "@Fit_page", "Képernyőhöz igazítás" },
	{ "@Fit_height", "Magassághoz igazítás" },
	{ "@Full_size", "Eredeti méret" },
	{ "@Custom_zoom", "Egyedi nagyítás" },
	{ "@Custom_scale", "Egyedi nagyítás mértéke" },
	// This is for toggling the display of the status bar.
	{ "@Toggle_status_bar", "Állapotsáv BE/KI" },
	// This is for cropping margins.
	{ "@Crop_margins", "Cropping margins" },
	{ "@Crop_toggle", "Toggle cropping margins" },
	{ "@Crop_margin_size", "Size of margin after cropping" },
	{ "@Crop_margin_thresh", "Threshold (in pixels) for margin detection" },
	// This is for the detection of cartoon panels.
	{ "@Panel_detection", "Képregény panel navigáció" },
	{ "@Toggle_auto_panels", "Automatikus érzékelés az új oldalakon BE/KI" },
	{ "@Toggle_scale_panels", "Panelek képernyőhöz igazítása BE/KI" },
	{ "@Select_bkgd_shade", "Panelek közötti szín" },
	{ "@Bkgd_lgrey", "Világosszürke" },
	// This is for the custom scale keyboard.
	{ "@Enter_scale", "Nagyítás mértéke (%-ban)" },
	{ "@Custom_offset", "Egyedi nagyítás offset" },
	// This is for the custom offset keyboard.
	{ "@Enter_offset", "Vízszintes offset (negatív érték megadásához a számot kezdd egy 0-val) " },
	// This is for setting the custom layout with the pointer.
	{ "@Custom_layout", "Egyedi elrendezés (mutatóval)" },
	{ "@Set_scale_ptr", "Rajzolj egy vízszintes vonalat balról jobbra, hogy ránagyíts a képnek arra a részére, és rajzolj egyet jobbról balra a nagyítás visszaállításához." },
	// This is for the directory selector.
	{ "@Open_dir", "A képeket tartalmazó mappa megnyitása" },
	// This is for failed unpacking of archive file.
	{ "@Unpack_fail", "A kibontási művelet nem sikerült" },
	// This is for the dialog for the next archive to open
	{ "@Open_next", "A jelenlegi archívum végére értél. Megnyissam a következőt?" },
	// These are for the display parameters.
	{ "@Display_params", "Megjelenítési beállítások" },
	{ "@Brightness", "Világosság" },
	{ "@Contrast", "Kontraszt" },
	{ "@Gamma", "Gamma" },
	{ "@Depth", "Colour depth" },
	// These are for the Help dialog.
	{ "@Button_help_title", "Gombokhoz rendelt műveletek:" },
	{ "@Help_back", "Következő lépés kisebbé tétele (2-vel osztás minden gombnyomáskor) /\n  Panel mód kikapcsolása az adott oldalon" },
	{ "@Help_left", "Lépés balra / Előző oldal / Balra lévő panel" },
	{ "@Help_right", "Lépés jobbra / Következő oldal / Jobbra lévő panel" },
	{ "@Help_panel_left", "Képregény panelek érzékelése jobbról balra" },
	{ "@Help_panel_right", "Képregény panelek érzékelése balról jobbra" },
	{ "@Help_up", "Lépés felfelé / Előző oldal / Fentebb lévő panel" },
	{ "@Help_down", "Lépés lefelé / Következő oldal / Lentebb lévő panel" },
	{ "@Help_prev", "Lépés felfelé / Előző oldal / Balra lévő panel" },
	{ "@Help_next", "Lépés lefelé / Következő oldal / Jobbra lévő panel" },
	{ "@Gesture_help_title", "Two-finger gestures:" },
	{ "@Two-finger_tap", "Tap" },
	{ "@Two-finger_pinch", "Pinch" },
	{ "@Two-finger_swipe", "Swipe" },
	{ "@Help_swipe", "Rotate screen toward swipe direction" },
	{ "@Help_unzoom", "Unzoom" },
	{ "@Translation_by", "GyéBen" },	//Translators, put your name there.
	// These are for the About dialog.
	{ "@About", "A pbimageviewer névjegye" },
	{ NULL, NULL }
};

trans_t trans_pl[] = {
	{ "@Program_name", "pbimageviewer" },
	// These are for the configuration menus.
	{ "@Conf_title", "Pbimageviewer konfiguracja" },
	{ "@Conf_def_info", "Ustawienia nowo otwartych książek:" },
	{ "@Default_zoom_hint", "Dopasowanie stron do ekranu" },
	{ "@Fine_update", "Detaliczne odświerzanie" },
	{ "@Fine_update_hint", "lepsza jakość wyświetlania stron na starszych czytnikach" },
	{ "@Show_status_bar", "włącz pasek informacyjny" },
	{ "@Status_bar_hint", "wyświetlaj pasek infomacyjny na dole ekranu" },
	{ "@Conf_sys_info", "ustawienia przeglądarki:" },
	{ "@Unpack_tmp", "dekompresuj pliki w katalogu /tmp " },
	{ "@Unpack_tmp_hint", "użyj w wypadku błędów w trakcie dekompresji w katalogu standartowym" },
	{ "@Check_rar_images", "sprawdzaj pliki graficzne przy dekompresji archiwów RAR/CBR" },
	{ "@Check_rar_images_hint", "użyj aby usuwać uszkodzone pliki z listy" },
	{ "@Step_percent", "stopnie poziomu powiększania w procentach wielkości ekranu" },
	{ "@Step_percent_hint", "użyj aby zwiększyć lub zmniejszyć stopnie" },
	{ "@Reset_page", "zaczynaj od początku jeżeli plik został przeczytany do końca" },
	{ "@Reset_page_hint", "Restart plików zamkniętych na ostatniej stronie" },
	{ "@Start_next", "Otwórz następny plik po zakończeniu aktualnego" },
	{ "@Start_next_hint", "Użyj aby wygodniej czytać serie wielotomowe" },
	{ "@Open_orient", "początkowa orientacja ekranu" },
	{ "@Open_orient_hint", "ignorowane przy urzyciu automatycznej orientacji" },
	{ "@Autorotate", "automatyczny obrót grafik formatu poziomowego" },
	{ "@Autorotate_hint", "opcja jest ignorowana w razie urzytku orientacji automatycznej" },
	{ "@pbiv_log_dir", "ścierzka pbiv.log" },
	// These are for the application menus.
	{ "@Fine_updates", "przełącz detaliczne odświerzanie" },
	{ "@Fit_default", "dopasuj do strony w pionie, dopasuj do szerokości w poziomie" },
	{ "@Fit_double", "dopasuj do wysokości w pionie, dopasuj do szerokości w poziomie" },
	{ "@Fit_page", "dopasuj do strony" },
	{ "@Fit_height", "dopasuj do wysokości" },
	{ "@Full_size", "wielkość rzeczywista" },
	{ "@Custom_zoom", "powiększenie własne" },
	{ "@Custom_scale", "skala powiększenia własnego" },
	// This is for toggling the display of the status bar.
	{ "@Toggle_status_bar", "wyświetlaj pasek informacyjny" },
	// This is for cropping margins.
	{ "@Crop_margins", "przycinanie marginesów" },
	{ "@Crop_toggle", "przycinaj marginesy" },
	{ "@Crop_margin_size", "wielkość marginesów po przycięciu" },
	{ "@Crop_margin_thresh", "wartość progowa (w pikselach) rozpoznania marginesów" },
	// This is for the detection of cartoon panels.
	{ "@Panel_detection", "rozpoznawanie kadrów" },
	{ "@Toggle_auto_panels", "przełącz rozpoznawanie kadrów" },
	{ "@Toggle_scale_panels", "przełącz automatyczne skalowanie kadrów do ekranu" },
	{ "@Select_bkgd_shade", "dobierz kolor tła między kadrami" },
	{ "@Bkgd_lgrey", "Jasnoszary" },
	// This is for the custom scale keyboard.
	{ "@Enter_scale", "Skala powiększenia (%)" },
	{ "@Custom_offset", "horyzontalne przesunięcie strony" },
	// This is for the custom offset keyboard.
	{ "@Enter_offset", "ustaw przesunięcie horyzontalne (prowadzące zero dla wartośći negatywnych)" },
	// This is for setting the custom layout with the pointer.
	{ "@Custom_layout", "układ indywidualny (wskaźnikiem)" },
	{ "@Set_scale_ptr", "Pociągnij linie horyzontalną z lewej do prawej aby powiększyć na wybrany obszar, lub z prawej do lewej aby zmniejszyć aktualny wybór do długośći linii." },
	// This is for the directory selector.
	{ "@Open_dir", "Otwóż katalog z plikami graficznymi" },
	// This is for failed unpacking of archive file.
	{ "@Unpack_fail", "Błąd w trakcie dekompresji." },
	// This is for the dialog for the next archive to open
	{ "@Open_next", "Koniec aktualnego pliku. Otworzyć następny?" },
	// These are for the display parameters.
	{ "@Display_params", "Ustawienia ekranu" },
	{ "@Brightness", "Jasność" },
	{ "@Contrast", "Kontrast" },
	{ "@Gamma", "Gamma" },
	{ "@Depth", "Głębia kolorów" },
	// These are for the Help dialog.
	{ "@Button_help_title", "Funkcje przycisków:" },
	{ "@Help_back", "zmniejsz następny krok (każde przyciśnięcie dzieli przez dwa) /\n  wyłącz tryb kadrowy na aktualnej stronie." },
	{ "@Help_left", "krok w lewo / poprzednia strona / poprzedni kadr" },
	{ "@Help_right", "krok w prawo / następna strona / następny kadr" },
	{ "@Help_panel_left", "rozpoznawaj kadry od prawej do lewej" },
	{ "@Help_panel_right", "rozpoznawaj kadry od lewej do prawej" },
	{ "@Help_up", "do góry / poprzednia strona / kadr wyżej" },
	{ "@Help_down", "w dół / następna strona / kadr niżej" },
	{ "@Help_prev", "krok wprzód / poprzednia strona / poprzedni kadr" },
	{ "@Help_next", "krok wstecz / następna strona / następny kadr" },
	{ "@Gesture_help_title", "gesty dwoma palcami:" },
	{ "@Two-finger_tap", "puknięcie" },
	{ "@Two-finger_pinch", "szczypnięcie" },
	{ "@Two-finger_swipe", "przetarcie" },
	{ "@Help_swipe", "obróć stronę w kierunku przetarcia" },
	{ "@Help_unzoom", "wycofaj powiększenie" },
	{ "@Translation_by", "Kamil Stefanowski" },	//Translators, put your name there.
	// These are for the About dialog.
	{ "@About", "o pbimageviewerze" },
	{ NULL, NULL }
};

trans_t trans_bg[] = {
	{ "@Program_name", "Разглеждач на изображения" },
	// These are for the configuration menus.
	{ "@Conf_title", "Конфигурация на разглеждача" },
	{ "@Conf_def_info", "Първоначални настройки за новоотворени книги:" },
	{ "@Default_zoom_hint", "Как всяка страница се побира в екрана" },
	{ "@Fine_update", "Фино опресняване" },
	{ "@Fine_update_hint", "Извършване на фино опресняване след пълно опресняване" },
	{ "@Show_status_bar", "Показване на лентата на състоянието" },
	{ "@Status_bar_hint", "Показване на информационна лента в долната част на екрана" },
	{ "@Conf_sys_info", "Целосистемни настройки:" },
	{ "@Unpack_tmp", "Разопаковане на архивите в папка /tmp" },
	{ "@Unpack_tmp_hint", "Използвайте това, ако ви излизат грешки при разопаковането в първоначалната папка" },
	{ "@Check_rar_images", "Проверка на снимките при отваряне на RAR и CBR архиви" },
	{ "@Check_rar_images_hint", "Използвайте това за премахване на недействителни изображения от списъка" },
	{ "@Step_percent", "Размер на стъпката като процент от размера на екрана" },
	{ "@Step_percent_hint", "Използвайте това, за да увеличите или намалите стъпките" },
	{ "@Reset_page", "Отваряне в началото, ако архива е бил завършен предния път" },
	{ "@Reset_page_hint", "Рестартиране на архивите, които са били затворени на последната страница" },
	{ "@Start_next", "Питане за отваряне на следващия архив в края на текущия" },
	{ "@Start_next_hint", "Използвайте това за по-лесно четене на поредица" },
	{ "@Open_orient", "Първоначална ориентация на екрана" },
	{ "@Open_orient_hint", "Това се пренебрегва, ако се използва автоматична ориентация" },
	{ "@Autorotate", "Автоматично завъртане на пейзажни изображения" },
	{ "@Autorotate_hint", "Това се пренебрегва, ако се използва автоматична ориентация" },
	{ "@pbiv_log_dir", "Местоположение на pbiv.log" },
	// These are for the application menus.
	{ "@Fine_updates", "Превключване на фино опресняване" },
	{ "@Fit_default", "Портрет: поместване на страницата, Пейзаж: поместване по ширина" },
	{ "@Fit_double", "Портрет: поместване по височина, Пейзаж: поместване по ширина" },
	{ "@Fit_page", "Поместване на страницата" },
	{ "@Fit_height", "Поместване по височина" },
	{ "@Full_size", "100% мащаб" },
	{ "@Custom_zoom", "Потребителски мащаб" },
	{ "@Custom_scale", "Ниво на мащаба" },
	// This is for toggling the display of the status bar.
	{ "@Toggle_status_bar", "Превключване на лентата на състоянието" },
	// This is for cropping margins.
	{ "@Crop_margins", "Отрязване на полета" },
	{ "@Crop_toggle", "Превключване на отрязването" },
	{ "@Crop_margin_size", "Размер след отрязване" },
	{ "@Crop_margin_thresh", "Праг за откриване (в пиксели)" },
	// This is for the detection of cartoon panels.
	{ "@Panel_detection", "Навигация на панелите на комикси" },
	{ "@Toggle_auto_panels", "Превключване на автоматичното откриване в нови страници" },
	{ "@Toggle_scale_panels", "Превключване на автоматичното напасване към екрана" },
	{ "@Select_bkgd_shade", "Цвят между панелите" },
	{ "@Bkgd_lgrey", "Светлосив" },
	// This is for the custom scale keyboard.
	{ "@Enter_scale", "Ниво на мащаба (%)" },
	{ "@Custom_offset", "Изместване на мащаба" },
	// This is for the custom offset keyboard.
	{ "@Enter_offset", "Хориз. изместване (започнете с '0' за отриц. стойности)" },
	// This is for setting the custom layout with the pointer.
	{ "@Custom_layout", "Собствено оформление (с показалец)" },
	{ "@Set_scale_ptr", "Начертайте хоризонтална линия от ляво надясно за постоянно увеличение в тази част на изображението. Начертайте линия от дясно наляво за постоянно намаляване и поместване на мащаба в линията." },
	// This is for the directory selector.
	{ "@Open_dir", "Отваряне на папка с изображения" },
	// This is for failed unpacking of archive file.
	{ "@Unpack_fail", "Разопаковането се провали" },
	// This is for the dialog for the next archive to open
	{ "@Open_next", "Край на текущия архив. Да се отвори ли следващия?" },
	// These are for the display parameters.
	{ "@Display_params", "Настройки на екрана" },
	{ "@Brightness", "Яркост" },
	{ "@Contrast", "Контраст" },
	{ "@Gamma", "Гама" },
	{ "@Depth", "Дълбочина на цветовете" },
	// These are for the Help dialog.
	{ "@Button_help_title", "Действия за копчетата:" },
	{ "@Help_back", "Направи следващата стъпка по-малка (разделяне с 2 за всяко натискане) /\n  Изключване на панелния режим за страницата" },
	{ "@Help_left", "Стъпка наляво / Предишна страница / Предишен панел" },
	{ "@Help_right", "Стъпка надясно / Следваща страница / Следващ панел" },
	{ "@Help_panel_left", "Откриване на панели от дясно наляво" },
	{ "@Help_panel_right", "Откриване на панели от ляво надясно" },
	{ "@Help_up", "Стъпка нагоре / Предишна страница / Панел отгоре" },
	{ "@Help_down", "Стъпка надолу / Следваща страница / Панел отдолу" },
	{ "@Help_prev", "Стъпка назад / Предишна страница / Предишен панел" },
	{ "@Help_next", "Стъпка напред / Следваща страница / Следващ панел" },
	{ "@Gesture_help_title", "Жестове с два пръста:" },
	{ "@Two-finger_tap", "Потупване" },
	{ "@Two-finger_pinch", "Защипване" },
	{ "@Two-finger_swipe", "Замахване" },
	{ "@Help_swipe", "Завъртане на екрана в посока на замаха" },
	{ "@Help_unzoom", "Премахване на мащабирането" },
	{ "@Translation_by", "Адмирал АнимЕ" },	//Translators, put your name there.
	// These are for the About dialog.
	{ "@About", "За програмата" },
	{ NULL, NULL }
};

#endif /* _TRANSLATIONS_H */
