/*
 * main.h
 *
 *  Created on: 25.01.2010
 *      Author: Admin
 */

#ifndef MAIN_H
#define MAIN_H

#include <stdio.h>
#include <string.h>
#include <string>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/mount.h>
#include <dlfcn.h>
#include "inkview.h"
#include "Viewer.h"
#include "ImagesMng.h"
#include "DevCaps.h"
#include "Log.h"

typedef struct settings_s {
	int magic;
	int page;
	int layout_mode;
	int custom_scale;
	int do_fine_update;
} Settings;

#define PBIVCFGFILE CONFIGPATH "/pbimageviewer.cfg"
#define DEFIMGSAVEPATH FLASHDIR "/pbiv-saved-images"

#define BUF_SIZE 1024

#ifndef EVT_MTSYNC
/* These are new definitions for multi-touch events not in the old SDK. */
#define EVT_MTSYNC 39
#define EVT_POINTERDRAG 44

typedef struct iv_mtinfo_s {
	int active;
	int x;
	int y;
	int pressure;
	int rsv_1;
	int rsv_2;
} iv_mtinfo;
#endif

#define ISTOUCHEVENT(x) ((x)>=39 && (x)<=44)

/* This is a new iconfigedit_s struct that's used on the 622. */
typedef struct iconfigedit_new_s {
	int type;
	const ibitmap *icon;
	char *text;
	char *hint;
	char *name;
	char *deflt;
	char **variants;
	struct iconfigedit_s *submenu;
	ibitmap **icon_theme;
} iconfigedit_new;

/* This is a new iv_mtinfo_s struct that is used on firmware 5.4 and above. */
typedef struct iv_mtinfo_54_s {
	int active;
	int x;
	int y;
	int pressure;
	int devtype;
	int rsv_2;
	long long timems;
} iv_mtinfo_54;


/* This defines the maximum pointer movement for a 'tap' */
#define PTR_EPS 20

/* These are the approximate half-size dimensions of the main menu */
#define MENU_HW 100
#define MENU_HH 120

extern "C" const ibitmap ci_about;
extern "C" const ibitmap ci_empty;

Viewer v;
ImagesMng mng;
DevCaps caps;
char dirbuff[BUF_SIZE];
char kbuf[BUF_SIZE];
std::string infile;
bool have_archive = false;
int lastmenuindex = 0;
enum menu_offsets { GOTO = 100, LAYOUT = 200, FINE = 300, STATUS = 400,
                    CROP = 500, PANEL = 600, CONF = 700, DISP = 800,
										DICT = 900, TURN = 1000, SAVE = 1100, TOC = 1200,
										HELP = 1300, ABOUT = 1400, EXIT = 1500 };
enum layout_modes { LAYOUT_DEFAULT, LAYOUT_FIT_PAGE, LAYOUT_FIT_HEIGHT, LAYOUT_FIT_WIDTH, LAYOUT_FULL_SIZE, LAYOUT_CUSTOM, LAYOUT_DOUBLE };
/* It's okay to add more to the following, but none should ever be removed. */
enum extra_settings { BRIGHTNESS, CONTRAST, GAMMA, DEPTH, READDIR };
char *layout_variants[] = { GetLangText("@Fit_default"), GetLangText("@Fit_page"), GetLangText("@Fit_height"), GetLangText("@Fit_width"), GetLangText("@Full_size"), GetLangText("@Custom_zoom"), GetLangText("@Fit_double"), NULL };
char *off_on_variants[] = { GetLangText("@Off"), GetLangText("@On"), NULL };
char *rot_variants[] = { GetLangText("@Rotate_0"), GetLangText("@Rotate_90"), GetLangText("@Rotate_270"), GetLangText("@Rotate_180"), NULL };
char *autorot_variants[] = { GetLangText("@Off"), GetLangText("@Rotate_90"), GetLangText("@Rotate_270"), NULL };
char *bc_variants[] = { "+128", "+96", "+64", "+32", "0", "-32", "-64", "-96", "-128", NULL };
char *gamma_variants[] = { "2.0", "1.8", "1.6", "1.4", "1.2", "1.0", "0.8", "0.6", "0.4", "0.2", NULL };
char *depth_variants[] = { "4", "8", "24", NULL };
enum depth_indexes { DEPTH4, DEPTH8, DEPTH24 };	/* Should match depth_variants */
char *margin_size_variants[] = { GetLangText("@border_small"), GetLangText("@border_medium"), GetLangText("@border_large"), NULL };
enum margin_size_indexes { MARGIN_SMALL, MARGIN_MEDIUM, MARGIN_LARGE };
char *margin_thresh_variants[] = { "2", "4", "8", NULL };
enum margin_thresh_indexes { MARGIN_THRESH_LOW, MARGIN_THRESH_MED, MARGIN_THRESH_HIGH };
char *logdir_variants[] = { GetLangText("@None"), GetLangText("@DeviceMemory"), GetLangText("@SDcard"), NULL };
char *readdir_variants[] = { GetLangText("@LeftToRight"), GetLangText("@RightToLeft"), NULL };
char *logdirs[] = { NULL, FLASHDIR, SDCARDDIR };
int layout_mode = LAYOUT_DEFAULT;
int step_divisor = 1;
int custom_scale = 100;
int custom_offset = 0;
bool do_fine_update = false;
bool do_draw_panel = true;
bool do_reset_last_page = false;
bool do_start_next_archive = false;
std::string next_archive;
char *image_save_dir = DEFIMGSAVEPATH;
char *lang = NULL;
iconfig *pbivcfg = NULL, *dispcfg = NULL;
tocentry *toc = NULL;
ibitmap *pagemap = NULL;
int X00, Y00, X10, Y10, X01, Y01, X11, Y11, pointing;
bool dont_redraw, setting_custom_layout, can_ask_for_password;
int start_orientation;
bool use_next_prev_for_stepping = false;
int brightness_idx, contrast_idx, gamma_idx, depth_idx;
iv_mtinfo* (*gti)(void);	/* Pointer to GetTouchInfo() function. */
int ptr_eps = 20;	/* Max. distance between touch down and up on tap events */
int autorot_idx = 0;

void draw();
void draw_pagemap();
void draw_panel(ibitmap *panelicon);
void show_page_info();
int main_handler(int type, int par1, int par2);
void dir_selected(char *path);
void menu_handler(int index);
void pageselect_handler(int pagenum);
void contents_handler(long long pos);
char* unpack_to_dir();
void apply_settings();
void save_settings();
void conf_handler();
void read_config();
void create_toc();
void get_new_translations();
void show_help();
void show_about();
void show_image(ibitmap *img);
void set_custom_layout(int x0, int x1);
void need_password();
void rotate_screen(int new_or);
void step(int direction);

#endif /* MAIN_H_ */
