#ifndef ZIPHANDLER_H_
#define ZIPHANDLER_H_

#include <string>
#include <vector>
#include <zip.h>
#include "ArchiveHandler.h"

class ZipHandler : ArchiveHandler {
	public:
		ZipHandler(std::string& outdir);
		~ZipHandler();
		int Open(std::string& path, std::vector<std::string>& files);
		int UnpackFile(std::string& name, std::string &outname);
	private:
		bool IsSupportedZipImage(const char *path);
		struct zip *_zip;
};

#endif /* ZIPHANDLER_H_ */
