/*
 * Viewer.h
 *
 *  Created on: 26.01.2010
 *      Author: Admin
 */

#ifndef VIEWER_H_
#define VIEWER_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <vector>
#include <algorithm>
#include "inkview.h"
#include "Log.h"

#define FIT_NOT					0							// Disable fit
#define FIT_WIDTH 				1							// Fit by width
#define FIT_HEIGHT 				2							// Fit by height
#define FIT_BOTH 				(FIT_WIDTH | FIT_HEIGHT)	// Fit by both
#define FIT_OVERSIZE			4							// Fit if oversize only
#define FIT_CUSTOM        8             // Use custom layout

#define DIRECTION_UP			1
#define DIRECTION_DOWN			2
#define DIRECTION_LEFT			4
#define DIRECTION_RIGHT			8
#define DIRECTION_HORIZONTAL	(DIRECTION_LEFT | DIRECTION_RIGHT)
#define DIRECTION_VERTICAL		(DIRECTION_UP | DIRECTION_DOWN)
#define DIRECTION_ALL			(DIRECTION_VERTICAL | DIRECTION_HORIZONTAL)

/* Use defines in infview.h
#define ALIGN_NONE				0
#define ALIGN_LEFT				1
#define ALIGN_CENTER			2
#define ALIGN_RIGHT				3
#define ALIGN_TOP				4
#define ALIGN_MIDDLE			8
#define ALIGN_BOTTOM			12
*/

#define MOVESTEP_25			0.25
#define MOVESTEP_50			0.5
#define MOVESTEP_80			0.8
#define MOVESPET_SCREEN		1.0

const double DEFSCALELINE[] = { .10, .25, .50, .75, 1.00, 1.25, 1.50, 2.00, 3.00, 0 };
const irect  DEFCLIPRECT 	= { 0, 0, 600, 800, 0 };

class Viewer
{
private:
	double* _scaleline;
	ibitmap* _image;
	double _scale, _fitscale, _movestep;
	irect _cliprect, _imagerect;
	int _fitmode;
	bool _do_panels, _do_auto_panels, _do_scale_panels;
	int _readdir;
	bool _do_crop;
	int _marginL, _marginR, _marginT, _marginB, _margin_size, _margin_thresh;
	std::vector<irect> _panels;
	int _current_panel;
	unsigned char _bkgd_threshold;
	unsigned char *mask, testpoints[4];
	void CalcFitScale();
	bool isBackground(int x, int y);
	irect FloodFill(int x, int y, unsigned char newVal, bool skipBkgdCheck);
	void ComputeBackground();
	void StartBkgdSearchAt(int x, int y, int xstep, int ystep);
	void DisplayPanel();
	void AlignPanel();
	int GetNextPanel(int direction);
	void MovePanel(int direction);
	void DrawPanelRect();
	void CalcMargins();
	int LeftMargin(){return (int)(_marginL*_scale+0.5);}
	int RightMargin(){return (int)(_marginR*_scale+0.5);}
	int TopMargin(){return (int)(_marginT*_scale+0.5);}
	int BottomMargin(){return (int)(_marginB*_scale+0.5);}
	int CroppedLPos(){return _imagerect.x + LeftMargin();}
	int CroppedRPos(){return _imagerect.x + _imagerect.w - RightMargin();}
	int CroppedW(){return _imagerect.w - LeftMargin() - RightMargin();}
	int CroppedTPos(){return _imagerect.y + TopMargin();}
	int CroppedBPos(){return _imagerect.y + _imagerect.h - BottomMargin();}
	int CroppedH(){return _imagerect.h - TopMargin() - BottomMargin();}
public:
	Viewer();
	~Viewer();

	void SetClipRect(irect* r){_cliprect = *r;}
	void SetClipRect(int x, int y, int w, int h);
	irect GetClipRect(){return _cliprect;}
	irect GetImageRect(){return _imagerect;}

	void SetImage(ibitmap* bit);
	bool CheckForNewImage(ibitmap *bit, bool update_testpoints = false);

	double GetScale(){return _scale;}
	void SetScale(double scale);
	void SetFitScale(double scale){_fitscale = scale;}
	void SetScaleline(double* scaleline){_scaleline = scaleline;}
	double* GetScaleline(){return _scaleline;}

	bool CanZoomIn();
	bool CanZoomOut();
	void ZoomIn();
	void ZoomOut();
	void Zoom100(){SetScale(1.0);}
	void ZoomFit(){SetScale(_fitscale);}
	void Zoom(int num);

	void SetFitMode(int mode){_fitmode = mode; CalcFitScale();}
	int GetFitMode(){return _fitmode;}

	void EnablePanelMode();
	void DisablePanelMode(){_do_panels = false;}
	bool IsPanelModeEnabled(){return _do_panels;}
	void ToggleAutoPanelMode(){_do_auto_panels = !_do_auto_panels; if(_do_auto_panels) EnablePanelMode(); else DisablePanelMode();}
	bool IsAutoPanelModeEnabled(){return _do_auto_panels;}
	void ToggleScalePanelMode(){_do_scale_panels = !_do_scale_panels;}
	bool IsScalePanelModeEnabled(){return _do_scale_panels;}
	void SetPanelBkgdThreshold(int t){if (t>=0 && t<=255) _bkgd_threshold = (unsigned char)t;}
	int GetPanelBkgdThreshold(){return _bkgd_threshold;}
	bool SetReadingDirection(int direction);
	int GetReadingDirection(){return _readdir;}

	void SetCroppedMargins(bool b){_do_crop = b;}
	bool IsCroppedMargins(){return _do_crop;}
	void ToggleCroppedMargins(){_do_crop = !_do_crop;}
	void SetMarginSize(int size){_margin_size = size;}
	void SetMarginThreshold(int thresh){_margin_thresh = thresh;}

	bool CanMove(int dx, int dy);
	void Move(int dx, int dy);
	void SetMoveStep(double step){_movestep = step < 0 ? 0 : step > 1 ? 1 : step;}
	double GetMoveStep(){return _movestep;}
	bool CanMoveDirection(int direction);
	void MoveDirection(int direction);
	void MoveAlign(int align);

	void Draw();
};

#endif /* VIEWER_H_ */
