/*
 * ImagesMng.h
 *
 *  Created on: 28.01.2010
 *      Author: Admin
 */

#ifndef IMAGESMNG_H_
#define IMAGESMNG_H_

#include <string>
#include <vector>
#include <algorithm>
#include <sys/types.h>

extern "C"{
#include <jpeglib.h>
}
#include "inkview.h"
#include "Log.h"
#include "ArchiveHandler.h"

class ImagesMng
{
private:
	ibitmap* _prev_img;
	ibitmap* _current_img;
	ibitmap* _next_img;

	std::string _dir;
	std::vector<std::string> _files;
	int _current_index;

	bool _applyLUT;
	unsigned char _lut[256];

	ibitmap* OpenBMP(const char* filename);
	ibitmap* OpenJPEG(const char* filename);
	ibitmap* OpenPNG(const char* filename);
	ibitmap* OpenGIF(const char* filename);
	ibitmap* OpenTIFF(const char* filename);

	ibitmap* OpenFile(std::string filename);
	int GetFileType(std::string path);
	void ClearBuffers();

	int _archive_type;
	bool unpack_in_tmp;
	ArchiveHandler *_archive_handler;
	std::string _passwd;
	enum supported_archives { UNSUPPORTED_ARCHIVE, TAR, TGZ, TBZ2, ZIP, RAR, C7Z };
	static int GetArchiveType(std::string path);
	void UnpackArchiveToDir(std::string& dir, std::string filename);
	void OpenArchive(std::string path, std::string filename);
	void OpenDir(std::string path, std::string filename);
	void PrepareImageFile(size_t index, std::string &filename);
	void ModifyImage(ibitmap *bm);
public:
	ImagesMng();
	~ImagesMng();

	enum supported_image_types { UNSUPPORTED_IMAGE, GIF, TIF, JPG, PNG, BMP };

	void Open(std::string path, std::string filename);
	void Open(std::string fullname);

	ibitmap* Current();
	ibitmap* Next();
	ibitmap* Prev();
	ibitmap* GoTo(int index);
	ibitmap* First(){return GoTo(0);}
	ibitmap* Last(){return GoTo(_files.size()-1);}
	bool HasNext(){return _current_index < (int)_files.size()-1;}
	bool HasPrev(){return _current_index > 0;}
	bool IsBuffered();
	void Buffering();

	std::string GetDirectory(){return _dir;}
	unsigned int GetFilesCount(){return _files.size();}
	int GetCurrentFileIndex(){return _current_index;}
	std::string GetFileName(size_t index);
	std::string GetFileFullame(size_t index);
	std::string GetCurrentFileName(){return GetFileName(_current_index);}
	std::string GetCurrentFileFullname(){return GetFileFullame(_current_index);}
	ibitmap* GetImage(size_t index);
	int SaveCurrentImage(char *dir);

	static bool IsSupportedArchive(std::string path);
	static bool HasSuffix(const char *path, const char *suf);
	static bool IsSupportedImage(const char *path);
	static int GetMagicType(char buf[8]);
	static void SetCheckRarMagic(bool _b);
	int CleanupArchive();
	void SetUnpackInTmp(bool _b){unpack_in_tmp = _b;}
	void SetPassword(char *password);
	void RecomputeLUT(int brightness, int contrast, double gamma);
	static void FileNameSort(std::vector<std::string> &names);
};

#endif /* IMAGESMNG_H_ */
