#ifndef DEVCAPS_H_
#define DEVCAPS_H_

#include <string>

struct DevCaps {
	bool has_dpad_buttons;
	bool has_mag_buttons;
	bool has_volume_buttons;
	bool has_back_button;
	bool has_menu_button;
	bool has_touchscreen;
	bool has_new_config_struct;
	unsigned int max_screen_depth;
	std::string device_model;
	std::string software_version;
	unsigned int model_num;
	unsigned int fw_major, fw_minor;
	unsigned int pagemap_margin, pagemap_width, pagemap_height;
	unsigned char pagemap_clear, pagemap_back, pagemap_fore;

	DevCaps();
	~DevCaps();
	void InitCaps();
	void ReadCaps();
	void LogCaps();
};

#endif /* DEVCAPS_H_ */
