/* makepatch.c -- Make a 'Patcher' style patch from differences between two binary files.

   Version 0.01, created 29 Sep 2016 by Geoffrey Reynolds.
   This file is hereby placed into the public domain.

   Compile: gcc -Wall -O -o makepatch makepatch.c
   Usage: makepatch OLDFILE NEWFILE

   Prints the byte differences between OLDFILE and NEWFILE on standard output
   in the form of a patch suitable for use as input to patch32lsb.

   OLDFILE and NEWFILE must be the same length.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define VERSION 0.01
#define CHUNKSIZE 8

int main(int argc, char **argv)
{
  FILE *infile[2];
  unsigned char bytes[2][CHUNKSIZE];
  unsigned long addr;
  int i;

  if (argc != 3) {
    fprintf(stderr, "Usage: makepatch OLDFILE NEWFILE\n");
    exit(EXIT_FAILURE);
  }

  for (i = 0; i < 2; i++) {
    if ((infile[i] = fopen(argv[i+1],"rb")) == NULL) {
      fprintf(stderr, "Failed to open input file: %s\n", argv[i+1]);
      exit(EXIT_FAILURE);
    }
  }

  printf("<Patch>\n");
  printf("patch_name = `Unknown`\n");
  printf("patch_enable = `no`\n");

  for (addr = 0; !feof(infile[0]); addr += CHUNKSIZE) {
    int len = fread(bytes[0],1,CHUNKSIZE,infile[0]);
    if (len != fread(bytes[1],1,CHUNKSIZE,infile[1]))
      break;
    if (memcmp(bytes[0],bytes[1],len)) {
      printf("replace_bytes = %.6lX,",addr);
      for (i = 0; i < len; i++)
	printf(" %.2X",bytes[0][i]);
      printf(",");
      for (i = 0; i < len; i++)
	printf(" %.2X",bytes[1][i]);
      printf("\n");
    }
  }

  for (i = 0; i < 2; i++) {
    if (!feof(infile[i])) {
      fprintf(stderr, "Files are not the same length\n");
      exit(EXIT_FAILURE);
    }
    fclose(infile[i]);
  }

  printf("</Patch>\n");

  exit(EXIT_SUCCESS);
}
