#!/usr/bin/env python
# coding=utf-8

"""
Input parser that takes:

(word1|word2, definition)

and generates

(word1, definition)
(word2, definition)
"""

__author__ = "Alberto Pettarin"
__copyright__ = "Copyright 2012-2016, Alberto Pettarin (www.albertopettarin.it)"
__license__ = "MIT"
__version__ = "3.1.3"
__email__ = "alberto@albertopettarin.it"
__status__ = "Production"


def parse(dictionary, arguments):
    """
    Given the input dictionary and arguments,
    return a (possibly, modified) dictionary.

    The returned dictionary might be the same (input) instance,
    or a new one.

    :param dictionary: the (raw) input dictionary
    :type  dictionary: Dictionary
    :param arguments: the command line arguments
    :type  arguments: Namespace from argparse
    :rtype: Dictionary
    """

    if dictionary is None:
        return None
    for entry in dictionary.entries:
        if "|" in entry.headword:
            # headword is of type "word1|word2" or "word1|word2|word3" or etc.
            words = entry.headword.split("|")
            definition = entry.definition
            # modify the original headword, keeping only word1
            entry.headword = words[0]
            # create new DictionaryEntry objects for the other words
            for w in words[1:]:
                dictionary.add_entry(headword=w, definition=definition)
        else:
            # nothing to do
            pass
    return dictionary
