#!/bin/sh
scriptdir=`/usr/bin/dirname "$0"`
cd $scriptdir

# runs on the iliad. Need to take output and use it to create results entries
# in the contentlister. Get it to create shortcuts/symlinks.
# iliad search only works in current directory and only seems to 
# search the title, not the description.

# 2008-04-12

## Set a limit for the number of results. 
LIMIT=40 
LOGFILE="../search-log.txt"

## Get the current path from the description field of the manifest in the config directory
STRING=`grep Description ../config/manifest.xml | sed -e 's/ *<Description>\(.*\)<\/Description>/\1/'` 

STARTDIR=$(awk '
BEGIN {FS=";"}
{
  if ($2 == STRING) {
    print $1
  }
}
' "STRING=$STRING" ../config/search.rc)



makeEntries () {
  awk '{
  RESDIR = "../results/res-"NR
  MANIFEST = RESDIR"/manifest.xml"
  system("mkdir -p " RESDIR)

  filename = $0
  print "<package>" > MANIFEST
  print "<symlink>" filename "</symlink>" >> MANIFEST
  print "</package>" >> MANIFEST
  }' match.lst

}


tooMany () {
mkdir ../results
cat <<EOF > ../results/manifest.xml
<?xml version="1.0" encoding="utf-8"?>                                                                                                                       
<package>                                                                                                                                                    
  <metadata>                                                                                                                                                 
    <dc-metadata>                                                                                                                                            
      <Title>Too many entries </Title>
      <Description>I found $NUMRECS matches and your limit is $LIMIT entries</Description>                              
      <Date>2007-03-13T09:25:00</Date>                                                                                                                       
    </dc-metadata>                                                                                                                                           
    <y-metadata>                                                                                                                                             
      <image></image>
      <version>000</version>                                                                                                                                 
    <ItemSize>327680</ItemSize></y-metadata>                                                                                                                 
  </metadata>                                                                                                                                                
</package>   
EOF

}


## Get the string to search for from the Description field of the manifest file
STRING=`grep Description manifest.xml | sed -e 's/ *<Description>\(.*\)<\/Description>/\1/'`

## Look for files that contain the string
# find "$STARTDIR" -type f -name 'manifest.xml' -print0 | xargs -0 grep -i "$STRING" | sed -e 's/\(.*\)\/manifest.xml.*/\1/' | uniq > match.lst
## Get around lack of -print0 and -0 in standard iliad busybox
find "$STARTDIR" -type f -name 'manifest.xml' > match.tmp
while read manifestFile; do
	grep -Hci "$STRING" "$manifestFile" ; 
done < match.tmp | awk 'BEGIN {FS=":"} {if ($2 > 0) print $1}' | sed -e 's/\(.*\)\/manifest.xml.*/\1/' > match.lst



## See how many matches we have
NUMRECS=$(wc -l match.lst | cut -f 1 -d" ")

## Decide if we should make contentlister entries or report too many results.
if [ $NUMRECS -ge $LIMIT ] ; then tooMany ; else makeEntries ; fi


### Some logging code. Could be done a lot better, but just need something for now.
echo This search was done on: $(date) > $LOGFILE
echo STARTDIR \(where the search will start from\): \"$STARTDIR\" >> $LOGFILE
echo STRING \(the string we are searching manifest files for\): $STRING >> $LOGFILE
awk 'END {print "Number of manifest.xml files found:", NR}' match.tmp >> $LOGFILE
awk 'END {print "Number of manifest.xml files that contain the search string:", NR}' match.lst >> $LOGFILE


rm match.lst match.tmp

## SAFER?
#<package>
# <metadata>
#  ...
# </metadata>
# <directory>
#  <content>/mnt/cf/documents</content>
# </directory>
#</package>
