#!/bin/sh
scriptdir=`/usr/bin/dirname "$0"`
cd $scriptdir

# 2008-04-28

## Get the current path from the description field of the manifest
STRING=`grep Description manifest.xml | sed -e 's/ *<Description>\(.*\)<\/Description>/\1/'` 

newDir=$(awk '
BEGIN {FS=";"; curdir=0}

{
  if (NR == 1) {
    firstRec = $2
  }

  if ($2 == STRING) {
    curdir=1
    next
  }
  if (curdir==1) {
    newDir = $2
    exit
  }
}

END {
if (newDir == "") {
  newDir = firstRec
}
print newDir
}

' "STRING=$STRING" search.rc)

sed -e "s/<Description>.*<\/Description>/<Description>$newDir<\/Description>/" manifest.xml > manifest.tmp
mv manifest.tmp manifest.xml

