/*
Run on kindle
Simulate touch screen event
Works on native reader & koreader

by lucida
*/

#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <netinet/in.h>
#include <string.h>
#include <fcntl.h>
#include <linux/input.h>
#include <err.h>
#include <errno.h>
#include <time.h>
#include <unistd.h>

void write_event(int fd, __u16 type, __u16 code, __s32 value)
{
  int ret;
  struct input_event event;
	memset(&event, 0, sizeof(event));
  event.type = type;
  event.code = code;
  event.value = value;
  ret = write(fd, &event, sizeof(event));

  if (ret < 0)
    perror("ERROR write_event");
  fsync(fd);
}

void fake_swipe(int fd, int x, int y, char ch)
{
  //For kindle, get sequence from "evtest /dev/input/eventX"
  int i = 0;
  write_event(fd, EV_KEY, BTN_TOUCH, 1);
  write_event(fd, EV_ABS, ABS_MT_SLOT, 0);
  write_event(fd, EV_ABS, ABS_MT_TRACKING_ID, 0);
  write_event(fd, EV_ABS, ABS_MT_POSITION_X , x);
  write_event(fd, EV_ABS, ABS_MT_POSITION_Y, y);
  write_event(fd, EV_SYN, 0, 0);
  write_event(fd, EV_KEY, BTN_TOOL_FINGER, 1);
  write_event(fd, EV_SYN, 0, 0);
  switch (ch)
  {
    case 'U': //up
      for ( i = 1; i<10; i++) {
        if (y-25*i > 0) {
          write_event(fd, EV_ABS, ABS_MT_POSITION_Y, y-25*i);
          write_event(fd, EV_SYN, 0, 0);
        }
        else
          break;
        }
      break;
    case 'D': //down
      for ( i = 1; i<10; i++) {
        if (y+25*i > 0) { //check resolution?
          write_event(fd, EV_ABS, ABS_MT_POSITION_Y, y+25*i);
          write_event(fd, EV_SYN, 0, 0);
        }
        else
          break;
        }
      break;
    case 'L': //LEFT
      for ( i = 1; i<10; i++) {
        if (x-25*i > 0) {
          write_event(fd, EV_ABS, ABS_MT_POSITION_X, x-25*i);
          write_event(fd, EV_SYN, 0, 0);
        }
        else
          break;
        }
      break;
    case 'R': //right
      for ( i = 1; i<10; i++) {
        if (x+25*i > 0) { //need to check resolution
          write_event(fd, EV_ABS, ABS_MT_POSITION_X, x+25*i);
          write_event(fd, EV_SYN, 0, 0);
        }
        else
          break;
        }
      break;
    default:
      break;
  }
    write_event(fd, EV_ABS, ABS_MT_TRACKING_ID , -1);
    write_event(fd, EV_SYN, 0, 0);
    write_event(fd, EV_KEY, BTN_TOUCH , 0);
    write_event(fd, EV_KEY, BTN_TOOL_FINGER, 0);
    write_event(fd, EV_SYN, 0, 0);
  return;
}

int main( int argc, char *argv[] ) {
	if (argc != 5) {
		printf("Usage: %s /dev/input/eventX x y direction(U/D/L/R)\n", argv[0]);
		return -1;
	}
  int touchfd = open(argv[1], O_RDWR);
  if (touchfd < 0)
  {
     printf("Failed to open %s\nRun as root/try other /dev/input/eventX\n", argv[1]);
     return -1;
  }
	int x = atoi(argv[2]);
	int y = atoi(argv[3]);
	printf("Device %s, point %d %d\n", argv[1], x, y);
  char c = *(argv[4]);
  fake_swipe(touchfd, x, y, c);
	close(touchfd);
  return 0;
}
