/*
Run on kindle
Simulate touch screen event
Works on native reader & koreader

by lucida
*/

#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <netinet/in.h>
#include <string.h>
#include <fcntl.h>
#include <linux/input.h>
#include <err.h>
#include <errno.h>
#include <time.h>
#include <unistd.h>

void write_event(int fd, __u16 type, __u16 code, __s32 value)
{
  int ret;
  struct input_event event;
	memset(&event, 0, sizeof(event));
  event.type = type;
  event.code = code;
  event.value = value;
  ret = write(fd, &event, sizeof(event));
  if (ret < 0)
    perror("ERROR write_event");
	fsync(fd);
}

void write_touch_event(int fd, int x, int y)
{
  //For kindle, get sequence from "evtest /dev/input/eventX"
  write_event(fd, EV_KEY, BTN_TOUCH, 1);
  write_event(fd, EV_ABS, ABS_MT_TRACKING_ID, 0);
  write_event(fd, EV_ABS, ABS_MT_POSITION_X , x);
  write_event(fd, EV_ABS, ABS_MT_POSITION_Y, y);
  write_event(fd, EV_SYN, 0, 0);
  write_event(fd, EV_KEY, BTN_TOOL_FINGER, 1);
  write_event(fd, EV_SYN, 0, 0);
  write_event(fd, EV_ABS, ABS_MT_TRACKING_ID , -1);
  write_event(fd, EV_SYN, 0, 0);
  write_event(fd, EV_KEY, BTN_TOUCH , 0);
  write_event(fd, EV_KEY, BTN_TOOL_FINGER, 0);
  write_event(fd, EV_SYN, 0, 0);
}

int main( int argc, char *argv[] ) {
	if (argc != 4) {
		printf("Usage: %s /dev/input/eventX x y\n", argv[0]);
		return -1;
	}
  int touchfd = open(argv[1], O_RDWR);
  if (touchfd < 0)
  {
     printf("Failed to open %s\nRun as root and try other /dev/input/eventX", argv[1]);
     return -1;
  }
	int x = atoi(argv[2]);
	int y = atoi(argv[3]);
	printf("Device %s, point %d %d\n", argv[1], x, y);
		write_touch_event(touchfd, x, y);
	close(touchfd);
  return 0;
}
