# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2016, DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.30"

from PyQt5.Qt import (Qt, QDialog, QFont, QIcon, QGridLayout, QGroupBox, QLabel, QMargins, QVBoxLayout, QWidget)

from calibre.utils.config import JSONConfig

S_FALSE = unicode("False")
S_TRUE = unicode("True")

# This is where all preferences for this plugin are stored
prefs = JSONConfig('plugins/Zotero Metadata Importer')

# Set defaults
prefs.defaults['ZMI_CONFIG_VERSION'] = unicode(__my_version__)
prefs['ZMI_CONFIG_VERSION'] = unicode(__my_version__)

prefs.defaults['ZMI_AUTO_VALIDATE_CUSTOM_COLUMNS_AT_STARTUP'] = S_FALSE
prefs.defaults['ZMI_PREFER_AUTO_STEP_MODE'] = S_FALSE

prefs.defaults['ZMI_MAXIMUM_FILE_ATTACHMENTS_TO_ADD_AUTOMATICALLY'] = unicode("200")

prefs.defaults['ZMI_CSV_IMPORT_HTML_TEXT_ALSO'] = S_FALSE
prefs.defaults['ZMI_CSV_IMPORT_EMPTY_FILE_ATTACHMENTS'] = S_FALSE

prefs.defaults['ZMI_PREFER_AUTO_TAGS_AS_STANDARD_TAGS'] = S_FALSE
prefs.defaults['ZMI_PREFER_MANUAL_TAGS_AS_STANDARD_TAGS'] = S_FALSE

prefs.defaults['ZMI_AUTO_SELECT_CSV_IMPORT_DIRECTORY'] = S_FALSE
prefs.defaults['ZMI_CSV_IMPORT_DIRECTORY_TO_USE'] = unicode("")
prefs.defaults['ZMI_CSV_ARCHIVE_DIRECTORY_TO_USE'] = unicode("")
prefs.defaults['ZMI_CSV_ARCHIVE_ORIGINALS'] = S_TRUE
prefs.defaults['ZMI_IGNORE_MAXIMUM_FILE_ATTACHMENTS_TO_AUTO_PROCESS'] = unicode("True")

prefs.defaults['ZMI_TEMP_DIRECTORY_SAME_AS_CALIBRE'] = S_TRUE
prefs.defaults['ZMI_TEMP_DIRECTORY_SPECIAL_SET'] = S_FALSE
prefs.defaults['ZMI_TEMP_DIRECTORY_SPECIAL_TO_USE'] = unicode("")
prefs.defaults['ZMI_TEMP_DIRECTORY_USE_TMPDIR'] = S_FALSE
empty_list = []
prefs.defaults['ZMI_TEMP_DIRECTORY_TO_DELETE_AT_SHUTDOWN'] = str(empty_list)

prefs.defaults['ZMI_MANUAL_MODE_REQUESTED_AFTER_RESTART'] = S_FALSE

prefs.defaults['ZMI_ZCOLUMNS_TO_CUSTOM_COLUMNS_MAPPING_PAIRS'] = unicode("#zotero_item_type:#my_text\n#zotero_pages:#my_integer\n#zotero_doi:#my_float\n#zotero_title:#my_comments\n#zotero_date_added:#my_datetime\n#zotero_doi:#my_boolean\n")

prefs.defaults['ZMI_ZOTERO_DATABASE_DIRECTORY'] = unicode("")


class ConfigWidget(QWidget):

    def __init__(self):

        QWidget.__init__(self)

        self.layout_1 = QVBoxLayout()
        self.setLayout(self.layout_1)

        self.layout_1.setSpacing(0)
        self.layout_1.setContentsMargins(QMargins(0,0,0,0));

        self.paths_groupbox = QGroupBox('Preferences')
        self.layout_1.addWidget(self.paths_groupbox)

        self.paths_layout = QGridLayout()
        self.paths_groupbox.setLayout(self.paths_layout)

        font = QFont()

        font.setBold(False)
        font.setPointSize(10)

        self.label1 = QLabel()
        self.label1.setTextFormat(1)
        self.label1.setText("<center><font color='#0404B4'>               Please Customize Directly Within Zotero Metadata Importer           </font></center>")
        self.label1.setFont(font)
        self.paths_layout.addWidget(self.label1)

        self.resize(self.sizeHint())

    def save_settings(self):
        return
    def validate(self):
        return False

#END of config.py

