# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2016, DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.35"

from calibre.customize import InterfaceActionBase

class ActionBaseZoteroMetadataImporter(InterfaceActionBase):

    name                    = 'Zotero Metadata Importer'
    description           = "Add Zotero books and their metadata to Calibre using a normal .csv file exported by Zotero."
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'DaltonST'
    version                 = (1, 0, 35)
    minimum_calibre_version = (2, 64, 0)

    actual_plugin           = 'calibre_plugins.zotero_metadata_importer.ui:ActionZoteroMetadataImporter'

    gui_name = 'Zotero Metadata Importer'

    #--------------------------------------------------------------------------------------------------------------------------
    def initialize(self):
        pass
    #--------------------------------------------------------------------------------------------------------------------------
    def is_customizable(self):
        return False
    #-------------------------------------------
#END of __init__py