/*

run on kindle
control page turn with evdev
Usage:
	kindle-evdev /dev/input/eventX btn1:x1,y1 btn2:x2,y2....
	
	/dev/input/eventX is the evdev event of OTG device


by lucida
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <fcntl.h>
#include <sys/poll.h>
#include <linux/input.h>
#include <err.h>
#include <time.h>
#include <errno.h>
#include <unistd.h>
#include <X11/extensions/XTest.h>

int getbtn(int fd)
{
	int btn = 0;
	struct input_event t;
	if (read(fd, &t, sizeof(t)) == sizeof(t))	{
		if (t.type == EV_KEY && t.value == 0)  //key released
			btn = t.code;
		else if (t.type == EV_REL && t.code == REL_WHEEL && t.value == 1)  //vscroll up
			btn = 9001;
		else if (t.type == EV_REL && t.code == REL_WHEEL && t.value == -1)  //vscroll down
			btn = 9002;
    else if (t.type == EV_REL && t.code == REL_HWHEEL && t.value == -1)  //hscroll left
      btn = 9003;
    else if (t.type == EV_REL && t.code == REL_HWHEEL && t.value == 1)  //hscroll right
      btn = 9004;


	}
	return btn;
}


void mouse_click(Display* dpy, int x, int y)
{
	XTestFakeMotionEvent (dpy, -1, x, y, CurrentTime);
	XTestFakeButtonEvent (dpy, 1, True,  CurrentTime);
	XTestFakeButtonEvent (dpy, 1, False, CurrentTime);
	XFlush(dpy);
}


int main(int argc,  char *argv[])
{
	int eventfd;
	struct pollfd mypoll;
	int btn = 0;

	if (argc < 3)
	{
		printf("Kindle OTG devices page turn using evdev\n");
		printf("Usage: %s /dev/input/eventX keycode1:x1,y1 keycode2:x2,y2\n", argv[0]);
		return -1;
	}

	eventfd = open(argv[1], O_RDONLY);
	if (eventfd < 0) //failed
	{	
		perror("ERROR Reading evdev device");
		return -1;
	}
	Display *dpy = NULL;
	dpy = XOpenDisplay(NULL);
	if ( dpy == NULL) {
		perror("ERROR Opening XDisplay");
		return -1;
	}

	int i, j;
	int *cmds = (int *)malloc(sizeof(int)*(argc-2)*3);
	//create cmds array: btn,x,y,btn,x,y....
	for ( i = 2; i<argc ; i++)   {
		j = i - 2;
		char* p = strsep(&argv[i], ":,");
		cmds[3*j] = atoi(p);
		p = strsep(&argv[i], ":,");
		cmds[3*j+1] = atoi(p);
		p = strsep(&argv[i], ":,");
		cmds[3*j+2] = atoi(p);
	}  


	mypoll.fd =  eventfd;
	mypoll.events = POLLIN;

	time_t latest_t, current_t;
	double diff_t = 0;
	time(&latest_t);
	while(1)	{
		if(poll(&mypoll, 1, 10) > 0)	{
			btn = getbtn(eventfd);
			if (btn <= 0)
				continue;
			int x = -1, y = -1;
			for (i=0; i < argc-2; i++)	{
				if (cmds[3*i] == btn) {
					x = cmds[3*i+1];
					y = cmds[3*i+2];
					break;
				}
			}
			printf("button: %d, point %d %d\n", btn, x, y);
			if (x > 0 && y > 0)   {
				mouse_click(dpy, x, y);
				time(&current_t);
				diff_t = difftime(current_t, latest_t);
				if (diff_t > 60) {//set every minute
					printf("Prevent sleep...\n");
					system("lipc-set-prop com.lab126.powerd -i touchScreenSaverTimeout 1");
					latest_t = current_t;
				}
			}
		}
	}
	close(eventfd);

	free(cmds);
	return 0;
}
