#!/bin/sh
# arg sanity check
if [ -z "$1" ]; then
	echo fail, enter search
	exit
fi

#adjust to your reality
export LD_LIBRARY_PATH=/mnt/us/extensions/xmahjongg/lib:$LD_LIBRARY_PATH
export PATH=/mnt/us/extensions/xmahjongg/bin:$PATH

wids=`xdotool search "$1"`
#wids=`xdotool search "$1" | tac` # optionally reverse the order
# reversing the order is often desirable to get multi layered windows to 
# display their chronologically last child as the front window.
echo "----------------------------"
echo "searching on $1"

# make it space free
INNER=`echo -ne $1 | sed 's/ //g'`
echo tidied name value is: $INNER
echo "----------------------------"

for wid in $wids; do
echo "window being processed --- $wid"

 #rename them
 #Portrait
 #xdotool set_window --name "L:A_N:application_ID:com.""$INNER""_PC:N" $wid
 #Landscape
 xdotool set_window --name "L:A_N:application_ID:com.""$INNER""_O:R_PC:N" $wid

 #stick them at the very top of the stack.
 # this order of iteration may not be the right one for all cases.
 xdotool windowreparent $wid `xwininfo -root | awk ' /xwininfo: Window id:/  {print $4}'`

done
