#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2016, John Howell <jhowell@acm.org>'
__docformat__ = 'restructuredtext en'


from calibre_plugins.overdrive_link.formats import (LEVEL_PDF, LEVEL_USER_KINDLE, LEVEL_SCRIBD_PDF)


# overrides for specific books
LEVEL_BY_BOOK_KEY = {
    '7d4964dd-b470-4eb7-8252-62ce18b4c021@': LEVEL_PDF,
    'B004XTKFWW@ak/': LEVEL_USER_KINDLE,
    'B00K3DPHQ6@ak/': LEVEL_USER_KINDLE,
    'B00K3DPOHI@ak/': LEVEL_USER_KINDLE,
    'B00KKRV8U4@ak/': LEVEL_USER_KINDLE,
    'B00KLQ7AXI@ak/': LEVEL_USER_KINDLE,
    'B00KOWDCR2@ak/': LEVEL_USER_KINDLE,
    'B00KQ3CTLY@ak/': LEVEL_USER_KINDLE,
    'B00KZP0NZC@ak/': LEVEL_USER_KINDLE,
    'B00MALUFN4@ak/': LEVEL_USER_KINDLE,
    'B00MD6NCUY@ak/': LEVEL_USER_KINDLE,
    'B00N43YH1S@ak/': LEVEL_USER_KINDLE,
    'B00N9BHCM6@ak/': LEVEL_USER_KINDLE,
    'B00NBAM9G4@ak/': LEVEL_USER_KINDLE,
    'B00NJ0FAIA@ak/': LEVEL_USER_KINDLE,
    'B00NJ0FD28@ak/': LEVEL_USER_KINDLE,
    'B01EPA28PA@ak/': LEVEL_USER_KINDLE,
    '155736003@sc/': LEVEL_SCRIBD_PDF,
    '199890249@sc/': LEVEL_SCRIBD_PDF,
    '233899322@sc/': LEVEL_SCRIBD_PDF,
    '233900591@sc/': LEVEL_SCRIBD_PDF,
    '233901178@sc/': LEVEL_SCRIBD_PDF,
    '233901397@sc/': LEVEL_SCRIBD_PDF,
    '233901612@sc/': LEVEL_SCRIBD_PDF,
    '233902339@sc/': LEVEL_SCRIBD_PDF,
    '233902546@sc/': LEVEL_SCRIBD_PDF,
    '235085265@sc/': LEVEL_SCRIBD_PDF,
    '246250036@sc/': LEVEL_SCRIBD_PDF,
    '246482471@sc/': LEVEL_SCRIBD_PDF,
    '252726223@sc/': LEVEL_SCRIBD_PDF,
    '257539819@sc/': LEVEL_SCRIBD_PDF,
    '258158436@sc/': LEVEL_SCRIBD_PDF,
    '260037333@sc/': LEVEL_SCRIBD_PDF,
    '262092733@sc/': LEVEL_SCRIBD_PDF,
    '262602742@sc/': LEVEL_SCRIBD_PDF,
    '263045166@sc/': LEVEL_SCRIBD_PDF,
    '267774734@sc/': LEVEL_SCRIBD_PDF,
    '268417404@sc/': LEVEL_SCRIBD_PDF,
    '268417438@sc/': LEVEL_SCRIBD_PDF,
    '268417446@sc/': LEVEL_SCRIBD_PDF,
    '268417450@sc/': LEVEL_SCRIBD_PDF,
    '268485021@sc/': LEVEL_SCRIBD_PDF,
    '27089643@sc/': LEVEL_SCRIBD_PDF,
    '270919598@sc/': LEVEL_SCRIBD_PDF,
    '270930961@sc/': LEVEL_SCRIBD_PDF,
    '270930963@sc/': LEVEL_SCRIBD_PDF,
    '273052089@sc/': LEVEL_SCRIBD_PDF,
    '276235971@sc/': LEVEL_SCRIBD_PDF,
    '276705587@sc/': LEVEL_SCRIBD_PDF,
    '282620550@sc/': LEVEL_SCRIBD_PDF,
    '282634009@sc/': LEVEL_SCRIBD_PDF,
    '282637708@sc/': LEVEL_SCRIBD_PDF,
    '283362387@sc/': LEVEL_SCRIBD_PDF,
    '285500007@sc/': LEVEL_SCRIBD_PDF,
    '285501930@sc/': LEVEL_SCRIBD_PDF,
    '286482665@sc/': LEVEL_SCRIBD_PDF,
    '286757844@sc/': LEVEL_SCRIBD_PDF,
    '287073282@sc/': LEVEL_SCRIBD_PDF,
    '290539878@sc/': LEVEL_SCRIBD_PDF,
    '292083664@sc/': LEVEL_SCRIBD_PDF,
    '31543876@sc/': LEVEL_SCRIBD_PDF,
    '263259647@sc/': LEVEL_SCRIBD_PDF,
    '282650161@sc/': LEVEL_SCRIBD_PDF,
    '282639251@sc/': LEVEL_SCRIBD_PDF,
    '250636029@sc/': LEVEL_SCRIBD_PDF,
    '246250043@sc/': LEVEL_SCRIBD_PDF,
    '294673746@sc/': LEVEL_SCRIBD_PDF,
    '294158220@sc/': LEVEL_SCRIBD_PDF,
    '259456960@sc/': LEVEL_SCRIBD_PDF,
    '297120906@sc/': LEVEL_SCRIBD_PDF,
    '302412575@sc/': LEVEL_SCRIBD_PDF,
    '303423667@sc/': LEVEL_SCRIBD_PDF,
    '300665737@sc/': LEVEL_SCRIBD_PDF,
    '306211431@sc/': LEVEL_SCRIBD_PDF,
    '292083661@sc/': LEVEL_SCRIBD_PDF,
    '310189019@sc/': LEVEL_SCRIBD_PDF,
    '310089533@sc/': LEVEL_SCRIBD_PDF,
    '311040167@sc/': LEVEL_SCRIBD_PDF,
    '315694931@sc/': LEVEL_SCRIBD_PDF,
    }


# override incorrect library book data
def fixup_book_data(log, lbook): 
    #log.info('check fixup: key=%s authors=%s' % (lbook.book_key, unicode(lbook.authors)))
    
    if lbook.book_key == 'c8f86423-b2ae-40f8-bfd8-e2ab30718497@' and tuple(lbook.authors) == ('John Varley',):
        log.info('Fixed: Rolling Thunder (incorrectly attributed to John Varley at OverDrive)')
        lbook.authors = ['Jack Terral']
        return
        
    if lbook.book_key == '627bd6d5-73f1-4e5f-b88a-cb6e8d46b989@' and tuple(lbook.authors) == ('Dave Barry Ridley Pearson',):
        log.info('Fixed: Author names merged for The Bridge to Never Land at OverDrive')
        lbook.authors = ['Dave Barry', 'Ridley Pearson']
        return
        
    if lbook.book_key == 'd7f35621-95e2-4ffa-80bc-3052a833caf3@' and lbook.title == "Year's Best Weird Fiction":
        log.info("Fixed: Year's Best Weird Fiction missing volume 1 at OverDrive")
        lbook.title = "Year's Best Weird Fiction, Volume 1"
        return
        
    if lbook.book_key == 'bd240752-c8e7-4f8b-8bd9-4270fb78e7a7@' and tuple(lbook.authors) == ('Dave Barry Ridley Pearson',):
        log.info('Fixed: Author names merged for Peter and the Secret of Rundoon at OverDrive')
        lbook.authors = ['Dave Barry', 'Ridley Pearson']
        return
    
    if lbook.book_key == '79389361-958b-4892-8c3f-94a3432a42c2@' and tuple(lbook.authors) == ('Paula Guran',):
        log.info('Fixed: The Year\'s Best Science Fiction & Fantasy, 2014 Edition (incorrectly attributed to Paula Guran at OverDrive)')
        lbook.authors = ['Rich Horton']
        return
        
    if lbook.book_key == '7a3366a2-e752-4695-a7de-4a9efa6e3fb1@' and lbook.title == 'A Novel':
        log.info('Fixed: Operation Chaos (incorrect title at OverDrive)')
        lbook.title = 'Operation Chaos'
        return
        
    if lbook.book_key == '8b2dcf00-c7ce-44da-bfa5-80f916b7d7c2@' and lbook.title == 'The Mammoth Book of Terror':
        log.info('Fixed: The Mammoth Book of New Terror (incorrect title at OverDrive)')
        lbook.title = 'The Mammoth Book of New Terror'
        return
        
    if lbook.book_key == '3a4eab79-b912-4901-91fa-377f6ac10b56@' and lbook.title == 'Fierce Reads: Kisses and Curses':
        log.info('Fixed: (Fierce Reads) Kisses and Curses (incorrect title at OverDrive)')
        lbook.title = '(Fierce Reads) Kisses and Curses'
        return
        
    if lbook.book_key == '234855674@sc/' and lbook.title == 'Gormenghast':
        log.info('Fixed: Gormenghast - A Stage Adaptation (incomplete title at Scribd)')
        lbook.title = 'Gormenghast - A Stage Adaptation'
        return
        
    if lbook.book_key == '262746908@sc/' and lbook.title.startswith('Ringworld:'):
        log.info('Fixed: Ringworld: The Graphic Novel, Part One (adjust title at Scribd)')
        lbook.title = 'Ringworld The Graphic Novel, Part One'
        return
        
    if (lbook.book_key in ['252006989@sc/', '233898872@sc/', 'B007EZJKS2@ak/', 
                '11342458@ho/', 'e6e9dd62-8f36-4825-b563-11c3abcdf9b9@']) and (
            lbook.title == 'The Last Unicorn' or lbook.title.startswith('The Last Unicorn (') 
            or lbook.title.startswith('The Last Unicorn:')):
        log.info('Fixed: The Last Unicorn Graphic Novel (incomplete title at Scribd/Amazon/Hoopla)')
        lbook.title = 'The Last Unicorn Graphic Novel'
        return
        
    if lbook.book_key == 'B00HSR4JUU@ak/' and lbook.title == 'Science Fiction: The Year\'s Best (2006 Edition)':
        log.info('Science Fiction, The Best of the Year, 2006 (Edition) (incorrect title and authors at Amazon)')
        lbook.title = 'Science Fiction, The Best of the Year, 2006 (Edition)'
        lbook.authors = ['Rich Horton', 'Michael Swanwick', 'Tom Purdom', 'Douglas Lain', 'James Patrick Kelly', 'Joe Haldeman',
                'Susan Palwick', 'Howard Waldrop', 'Wil McCarthy', 'Leah Bobet', 'Robert Reed', 'James Van Pelt',
                'Mary Rosenblum', 'Stephen Leigh', 'Daniel Kaysen', 'Alastair Reynolds']
        return
        
    if lbook.book_key == 'B00DRELAX2@ak/' and lbook.title == 'Fantasy: The Best of the Year (Fantasy: The Best of ... (Quality))':
        log.info('Science Fiction, The Best of the Year, 2006 (Edition) (incorrect title and authors at Amazon)')
        lbook.title = 'Fantasy, The Best of the Year, 2006 (Edition)'
        lbook.authors = ['Rich Horton', 'Theodora Goss', 'Gene Wolfe', 'Eric Schaller', 'Elizabeth Bea', 'Paul Di Filippo',
                'George Saunders', 'Samantha Henderson', 'Gregory Feeley', 'Neil Gaiman', 'Joe Murphy', 'Sonya Taaffe',
                'Marc Laidlaw', 'Pat Cadigan', 'Peter S. Beagle', 'Michael Canfield', 'Richard Parks', 'Steve Rasnic Tem',
                'Holly Phillips', 'Matthew Hughes']
        return
        
    if lbook.book_key == '229380421@sc/' and tuple(lbook.authors) == ('Danile C. Dennett',):
        log.info('Fixed: Kinds Of Minds: Toward An Understanding Of Consciousness (incorrect author spelling at Scribd)')
        lbook.authors = ['Daniel C. Dennett']
        return
        
    if lbook.book_key == '11461668@ho/' and lbook.title == 'Eclipse':
        log.info('Fixed: Eclipse One (incomplete title at Hoopla)')
        lbook.title = 'Eclipse One: New Science Fiction and Fantasy'
        return
        
    if lbook.book_key == '11461669@ho/' and lbook.title == 'Eclipse':
        log.info('Fixed: Eclipse Two (incomplete title at Hoopla)')
        lbook.title = 'Eclipse Two: New Science Fiction and Fantasy'
        return
        
    if lbook.book_key == '11461444@ho/' and lbook.title == 'Eclipse':
        log.info('Fixed: Eclipse Three (incomplete title at Hoopla)')
        lbook.title = 'Eclipse Three: New Science Fiction and Fantasy'
        return
        
    if lbook.book_key == '11461445@ho/' and lbook.title == 'Eclipse':
        log.info('Fixed: Eclipse Four (incomplete title at Hoopla)')
        lbook.title = 'Eclipse Four: New Science Fiction and Fantasy'
        return
        
    if lbook.book_key == '296189643@sc/': 
        log.info("Fixed: Sora's Quest by T. L. Shreffler (incorrect title and author at Scribd)")
        lbook.title = "Sora's Quest"
        lbook.authors = ['T. L. Shreffler']
        return
        
    if lbook.book_key == '314636376@sc/' and lbook.title == 'The Best Science Fiction of the Year, 2016':
        log.info('Fixed: The Best Science Fiction of the Year, Volume One (adjust title at Scribd)')
        lbook.title = 'The Best Science Fiction of the Year, Volume One'
        return
        
    if lbook.book_key == '922f8d68-a0ab-4cb0-ba39-b4149be37139@' and lbook.title == 'A Novel':
        log.info('Fixed: Steeplejack: A Novel (incorrect title at OverDrive)')
        lbook.title = 'Steeplejack: A Novel'
        return
        
