#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2016, John Howell <jhowell@acm.org>'
__docformat__ = 'restructuredtext en'

                
# Important release notes that need to be shown to the user after install of new version

# list of release notes as tuples of release version and html text, newest first

RELEASE_NOTES = [

    ((1, 37, 0), '''
<h3>Version 1.37.0</h3>
<p>Support a major change to the OverDrive website design being rolled out to lending libraries in 2016.
Most importantly for users of this plugin, the identifiers associated with books have changed, making links to book web pages
partially incompatible with the old website design. Links previously created by searching will still function after
a library migrates to the new website, but future searches will create different links and the old links will be removed.
(In order for old link removal to occur you must select the option <i>Unlink books if no longer found by search</i> in the
plugin configuration. Otherwise both old and new links will exist for the same book.)</p>
<p>Usually the library-id (website host name) of an OverDrive library will change when the library is migrated. The plugin detects
host name redirection during search and notifies you by an error message that a configuration change is needed. After updating the
configuration you should use the menu choice <i>Check and repair book links</i> to migrate existing book links to the new library-id.
(The plugin checks for host names changed by adding or removing ".lib.", which is what OverDrive does typically. If the host name
is changed in some other manner it will not be possible to migrate links and they will need to be re-established by performing
new searches.)</p>
<p>The plugin detects and keeps track of the website type (old or new) for each lending library. This may sometime fail causing
books links to work incorrectly. If this occurs a restart of calibre <i>should</i> correct the problem.
Once all libraries have migrated to the new design the plugin will be updated to remove support for old websites and
then this will no longer be an issue.</p>
<p>The process of signing in using the new website design has not yet been tested. If you experience a sign-in error then
clear the card number field in the plugin configuration for that lending library to avoid the sign-in process.</p>
    '''),
    
    ((1, 15, 0), '''
<h3>Version 1.15.0</h3>

<p>Changed both Amazon and Open Library to require the collection to be searched to be set as the library-id in the plugin
configuration. For libraries configured using a previous release of the plugin, <i>prime</i> will be assumed for Amazon and
<i>inlibrary</i> will be assumed for Open Library. Update your library configuration if something else is desired.</p>
<p>Added a menu choice, <i>Check and repair book links</i>, which will check the link identifiers for books in the calibre library
and discovered books for problems. Any incorrect links will be listed with the option to correct them.</p>
<p><b>Users of previous versions of this plugin should use <i>Check and repair book links</i> prior to doing any new searches
in order to migrate Amazon and Open Library links to be compatible with this plugin version.</b></p>

<p>See full release notes in "Help" for more information.</p>
    '''),
    
    ]

LAST_RELEASE_NOTE_VERSION = RELEASE_NOTES[0][0]
