﻿#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai

from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2016, John Howell <jhowell@acm.org>'
__docformat__ = 'restructuredtext en'

import json
import re

   
def js_value(log, js, prefix):
    # find right place in script for needed value
    # treat spaces as optional white space and * as matching arbitrary text for match
    
    #log.info('load: %s' % js)

    search_re = re.escape(' %s ' % prefix).replace(r'\*',r'.+?').replace(r'\ ',r'\s*')
    
    m = re.search(search_re, js)
    if not m:
        log.info('re: ' + search_re)
        log.info('script: ' + js)
        raise ValueError('Missing "%s" in script' % prefix)
        
    start_pos = i = m.end()
    start_char = js[start_pos]

    if start_char == '[':       # list
        end_char = ']'
    elif start_char == '{':     # dict
        end_char = '}'
    else:                       # simple value
        i -= 1
        start_char = None
        end_char = ';'
        
    # simple scan for terminator. Ignores braces in strings. and handles nesting
    level = 1
    in_string = False
    string_term = None
    esc_str = False
    
    while (level > 0):
        i += 1
        
        if i >= len(js):
            raise ValueError('Missing terminator')
            
        #log.info('ch="%s" end_char="%s" level=%d in_string=%s'%(js[i], end_char, level, unicode(in_string)))
        
        if not in_string:
            if js[i] == '"' or js[i] == "'":
                in_string = True
                esc_str = False
                string_term = js[i]
                js = js[:i] + '"' + js[i+1:]   # fix string for json
                
            elif js[i] == start_char:
                level += 1
                
            elif js[i] == end_char:
                level -= 1
                
        elif esc_str:
            esc_str = False
            
        elif js[i] == '\\':
            esc_str = True
            
        elif js[i] == string_term:
                in_string = False
                js = js[:i] + '"' + js[i+1:]   # fix string for json
            
    if js[i] == ';':
        i -= 1  # don't include semicolon terminator
        
    json_text = js[start_pos:i+1]
    
    #log.info('loading: %s' % json_text)
    
    try:
        json_data = json.loads(json_text)
        
    except:
        log.info('loading: %s'%json_text)
        raise
        
    #log.info('loaded: %s' % unicode(json_data))
    
    return json_data

