#!/bin/sh

#MODE 1: simulate mouse, native reader only; 
#MODE 2: simulate touch, native&koreader
MODE="1"

#point locations, for left/right/middle/wheel up/wheel down
LOWRES="500 400 100 400 300 50 100 400 500 400"
MIDRES="600 500 100 500 400 50 100 500 600 500"
HIRES="900 700 100 700 300 100 100 700 900 700"

# Get proper config per device
# value from koreader/frontend/device/kindle/device.lua
kMODEl="$(cut -c3-4 /proc/usid)"
case "${kMODEl}" in
	"13" | "54" | "2A" | "4F" | "52" | "53" )
	# Voyage, 1080x1440, /dev/input/event1
	echo /dev/input/event1 $MODE $HIRES
	exit 0
	;;
	"24" | "1B" | "1D" | "1F" | "1C" | "20" )
	# KPW1 768x1024, /dev/input/event0
	echo /dev/input/event0 $MODE $MIDRES
	exit 0
	;;
	"D4" | "5A" | "D5" | "D6" | "D7" | "D8" | "F2" | "17" | "60" | "F4" | "F9" | "62" | "61" | "5F" )
	# KPW2 768x1024, /dev/input/event1
	echo /dev/input/event1 $MODE $MIDRES
	exit 0
	;;  
	"0F" | "11" | "10" | "12" )
	# KT 600x800 /dev/input/event3
	echo /dev/input/event3 $MODE $LOWRES
	exit 0
	;;
	"C6" | "DD" )
	# KT2(Kindle Basic), 600x800 /dev/input/event1
	echo /dev/input/event1 $MODE $LOWRES
	exit 0
	;;
esac


# Try the new device ID scheme...
kMODElv2="$(cut -c4-6 /proc/usid)"
case "${kMODElv2}" in
	"0G1" | "0G2" | "0G4" | "0G5" | "0G6" | "0G7" | "0KB" | "0KC" | "0KD" | "0KE" | "0KF" | "0KG" )
	# PW3 1080x1440 /dev/input/event1
	echo /dev/input/event1 $MODE $HIRES
	exit 0
	;;
	"0GC" | "0GD" | "0GP" | "0GQ" | "0GR" | "0GS" )
	# KOA 1080x1440 /dev/input/by-path/platform-imx-i2c.1-event
	echo /dev/input/by-path/platform-imx-i2c.1-event $MODE $HIRES
	exit 0
	;;
	"0DT" | "0K9" | "0KA" )
	#KT3(KindleBasic2), 600x800 /dev/input/event0
	echo /dev/input/event0 $MODE $LOWRES
	exit 0
	;;
esac

echo "Device not found!!"
