#!/bin/sh


port="54321"
passwd="pass1234"

if [ X$1 == X"port" ]; then
  echo $port
  exit 0
fi

#uncomment the next two lines to use your own config
#echo /dev/input/event1 $port $passwd 900 700 100 700 500 100
#exit 0

# Get proper config
# value from koreader/frontend/device/kindle/device.lua

kmodel="$(cut -c3-4 /proc/usid)"
case "${kmodel}" in
	"13" | "54" | "2A" | "4F" | "52" | "53" )
	# Voyage, 1080x1440, /dev/input/event1
	echo /dev/input/event1 $port $passwd 900 700 100 700 500 100
	exit 0
	;;
	"24" | "1B" | "1D" | "1F" | "1C" | "20" )
	# KPW1 768x1024, /dev/input/event0
	echo /dev/input/event0 $port $passwd 600 500 100 500 400 50
	exit 0
	;;
	"D4" | "5A" | "D5" | "D6" | "D7" | "D8" | "F2" | "17" | "60" | "F4" | "F9" | "62" | "61" | "5F" )
	# KPW2 768x1024, /dev/input/event1
	echo /dev/input/event1 $port $passwd 600 500 100 500 400 50
	exit 0
	;;  
	"0F" | "11" | "10" | "12" )
	# KT 600x800 /dev/input/event3
	echo /dev/input/event3 $port $passwd 500 400 100 400 300 50
	exit 0
	;;
	"C6" | "DD" )
	# KT2(Kindle Basic), 600x800 /dev/input/event1
	echo /dev/input/event1 $port $passwd 500 400 100 400 300 50
	exit 0
	;;
esac


# Try the new device ID scheme...
kmodelv2="$(cut -c4-6 /proc/usid)"
case "${kmodelv2}" in
	"0G1" | "0G2" | "0G4" | "0G5" | "0G6" | "0G7" | "0KB" | "0KC" | "0KD" | "0KE" | "0KF" | "0KG" )
	# PW3 1080x1440 /dev/input/event1
	echo /dev/input/event1 $port $passwd 900 700 100 700 500 100
	exit 0
	;;
	"0GC" | "0GD" | "0GP" | "0GQ" | "0GR" | "0GS" )
	# KOA 1080x1440 /dev/input/event3
	echo /dev/input/event3 $port $passwd 900 700 100 700 500 100
	exit 0
	;;
	"0DT" | "0K9" | "0KA" )
	#KT3(with bt), 600x800 /dev/input/event1
	echo /dev/input/event1 $port $passwd 500 400 100 400 300 50
	exit 0
	;;
esac

echo "Device not found!!"
