/*
Run on kindle
Monitor incoming connection and turn page accordingly

write_event, write_touch_event is from h_q10's tapscreen.c

*/

#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <netinet/in.h>
#include <string.h>
#include <fcntl.h>
#include <linux/input.h>
#include <err.h>
#include <errno.h>
#include <time.h>

void write_event(int fd, struct input_event *event, __u16 type, __u16 code, __u32 value)
{
  int ret;
  struct timeval inc = {0, 8};

  event->type = type;
  event->code = code;
  event->value = value;
  ret = write(fd, event, sizeof(*event));
  if (ret < 0)
    err(errno, "write_event");
  timeradd(&event->time, &inc, &event->time);
}

void write_touch_event(int fd, struct input_event *event,
    int x, int y, int pressure, int touch)
{
  gettimeofday(&event->time, NULL);

  // defined values can find in include/uapi/linux/input.h
  //BTN_TOUCH = 0x14a = 330
  //BTN_TOOL_FINGER = 0x145 = 325
  //ABS_MT_POSITION_X  = 0x35 = 54
  //ABS_MT_POSITION_Y  = 0x36 = 55
  //  ABS_MT_TRACKING_ID  = 0x39 = 57

  /*kindle next page events:
type:ABS(03)  code=39 val=0
type:ABS(03)  code=35 val=662
type:ABS(03)  code=36 val=504
type:KEY(01)  code=14a  val=1
type:KEY(01)  code=145  val=1
type:SYN(00)  code=0  val=0
type:ABS(03)  code=39 val=-1
type:KEY(01)  code=14a  val=0
type:KEY(01)  code=145  val=0
type:SYN(00)  code=0  val=0
   */


  write_event(fd, event, EV_ABS, ABS_MT_TRACKING_ID, 0);
  write_event(fd, event, EV_ABS, ABS_MT_POSITION_X , x);
  write_event(fd, event, EV_ABS, ABS_MT_POSITION_Y, y);
  usleep(10000);
  write_event(fd, event, EV_KEY, BTN_TOUCH, 1);
  usleep(10000);
  write_event(fd, event, EV_KEY, BTN_TOOL_FINGER, 1);
  write_event(fd, event, EV_SYN, 0, 0);
  write_event(fd, event, EV_ABS, ABS_MT_TRACKING_ID , -1);
  usleep(10000);
  write_event(fd, event, EV_KEY, BTN_TOUCH , 0);
  usleep(10000);
  write_event(fd, event, EV_KEY, BTN_TOOL_FINGER, 0);
  write_event(fd, event, EV_SYN, 0, 0);

}

int main( int argc, char *argv[] ) {
	if (argc < 10) {
		printf("Usage: %s /dev/input/eventX port password pt_next_x pt_next_y pt_prev_x pt_prev_y pt_menu_x pt_menu_y\n", argv[0]);
		return -1;
	}
  int touchfd = open(argv[1], O_RDWR);
  if (touchfd < 0)
  {
     printf("Failed to open %s\nRun as root and try other /dev/input/eventX", argv[1]);
     return -1;
  }


	int sockfd, newsockfd, portno, clilen;
	char buffer[64];
	struct sockaddr_in serv_addr, cli_addr;
	struct input_event event;
	int  n;

	/* First call to socket() function */
	sockfd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
	int iSetOption = 1;
	setsockopt(sockfd, SOL_SOCKET, SO_REUSEADDR, (char*)&iSetOption,sizeof(iSetOption));

	if (sockfd < 0) {
		perror("ERROR opening socket");
	  return -1;
	}

	/* Initialize socket structure */
	bzero((char *) &serv_addr, sizeof(serv_addr));
	portno = atoi(argv[2]);

	serv_addr.sin_family = AF_INET;
	serv_addr.sin_addr.s_addr = INADDR_ANY;
	serv_addr.sin_port = htons(portno);

	/* Now bind the host address using bind() call.*/
	if (bind(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0) {
		perror("ERROR on binding");
		return -1;
	}

	/* Now start listening for the clients, here process will
	 * go in sleep mode and will wait for the incoming connection
	 */

	listen(sockfd,5);
	clilen = sizeof(cli_addr);

	int points[6] = {-1};
	int i = 0;
	for (i = 0; i < 6; i++)
		points[i] = atoi(argv[i+4]);
  
  time_t latest_t, current_t;
  double diff_t = 0;
  time(&latest_t);
  
	char buff[64];
	while(1) {  
		/* Accept actual connection from the client */
		newsockfd = accept(sockfd, (struct sockaddr *)&cli_addr, &clilen);

		if (newsockfd < 0) {
			perror("ERROR on accept");
			continue;
		}

		/* If connection is established then start communicating */
		bzero(buffer,sizeof(buffer));
		n = read( newsockfd,buffer,sizeof(buffer)-1 );

		if (n < 0) {
			perror("ERROR reading from socket");
			continue;
		}

		int mode = -1;

 		//buff[64]
		bzero(buff, sizeof(buff));
    strncpy(buff, argv[3], 40);
		if (strcmp(buffer, strcat(buff,"NEXT")) == 0 )
			mode = 1;
    strncpy(buff, argv[3], 40);
    if (strcmp(buffer, strcat(buff, "PREV")) == 0)
			mode = 2;
    strncpy(buff, argv[3], 40);
    if (strcmp(buffer, strcat(buff, "MENU")) == 0)
			mode = 3;
	if (mode == -1) continue;
	int x = points[mode*2-2];
	int y = points[mode*2-1];
    printf("Incoming message: %s, mode %d, point %d %d\n",buffer, mode, x, y);

	if ( x >= 0 & y >= 0) 
		{	
		write_touch_event(touchfd, &event, x, y, 100, 1);
		time(&current_t);
		diff_t = difftime(current_t, latest_t);
		if (diff_t > 60) //set every minute
			{
			printf("Prevent sleep...\n");
			system("lipc-set-prop com.lab126.powerd -i touchScreenSaverTimeout 1");
			latest_t = current_t;
			}
		}	
  }
  return 0;
}
