#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys/poll.h>
#include <sys/select.h>
#include <linux/input.h>
#include <err.h>
#include <errno.h>
#include <netdb.h>
#include <netinet/in.h>


int getbtn(int fd)
{
	int btn = 0;
	struct input_event t;
	if (read(fd, &t, sizeof(t)) == sizeof(t))
	{
		if  (t.type == EV_KEY && t.value == 1) //key pressed
			btn = t.code;
	}
	return btn;
}

int sendcmd(char* kindleip, char* kindleport, char* passwd, int mode )
{
	if (mode < 0) 
		return -1;

	char cmd[64] = "";
	switch(mode) {
		case 1:
			strncpy(cmd, passwd,40);
			strcat(cmd, "NEXT");
			break;
		case 2:
			strncpy(cmd, passwd,40);
			strcat(cmd, "PREV");
			break;
		case 3:
			strncpy(cmd, passwd,40);
			strcat(cmd, "MENU");
			break;
	}

	int sock = -1;
	fd_set fdset;
	struct timeval tv;

	struct sockaddr_in client_addr;  
	bzero((char *) &client_addr, sizeof(client_addr));  
	client_addr.sin_family = AF_INET;
	client_addr.sin_addr.s_addr = htons(INADDR_ANY); 
	client_addr.sin_port = htons(0); 

	int client_socket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
	//int client_socket = socket(AF_INET, SOCK_DGRAM, 0);  

	if (client_socket < 0)  
	{  
		printf("Create Socket Failed!\n");  
		return -1;  
	}  		

	if (bind(client_socket, (struct sockaddr*)&client_addr, sizeof(client_addr)))  
	{  
		printf("Client Bind Port Failed!\n");  
		return -1;  
	}


	struct sockaddr_in  server_addr;  
	bzero(&server_addr, sizeof(server_addr));  
	server_addr.sin_family = AF_INET;  
	server_addr.sin_addr.s_addr = inet_addr(kindleip);
	server_addr.sin_port = htons(atoi(kindleport));  

	/* use 'select' with timeout instead 
		 socklen_t server_addr_length = sizeof(server_addr);
		 if (connect(client_socket, (struct sockaddr*)&server_addr, server_addr_length) < 0)  
		 {  
		 printf("Can Not Connect To %s!\n", kindleip);  
		 return -1;  
		 }
		 send(client_socket, cmd, sizeof(cmd),0);

		 return 0;
	 */
	int rc = fcntl(client_socket, F_SETFL, fcntl(client_socket, F_GETFL, 0) | O_NONBLOCK);
	if (rc == -1)
		{
			perror("FCNTL error");
			close(client_socket);
			return;
}
	rc = connect(client_socket, (struct sockaddr *)&server_addr, sizeof(server_addr));
	//printf("rc %d\n", rc);
	if (rc == 0) 
	{
		send(client_socket, cmd, sizeof(cmd),0);
		close(client_socket);
		return;
	}

	//rc = -1
	FD_ZERO(&fdset);
	FD_SET(client_socket, &fdset);
	tv.tv_sec = 4;       //4s
	tv.tv_usec = 0; //0ms timeout

	if (select(client_socket + 1, NULL, &fdset, NULL, &tv) == 1)
	{
		int so_error;
		socklen_t len = sizeof(so_error);
		getsockopt(client_socket, SOL_SOCKET, SO_ERROR, &so_error, &len);
		//printf("so_error: %d\n", so_error);
		if (so_error == 0) {
			printf("Send cmd: %s\n", cmd);
			send(client_socket, cmd, sizeof(cmd),0);
		}
	}
	else
	{
		printf("timeout\n");		
	}


	close(client_socket);
	return 0;

}
int main(int argc,  char *argv[])
{
	int eventfd;
	struct pollfd  mypoll;
	int btn = 0;

	if (argc != 8)
	{
		printf("Monitor keystrok and send command to kindle\n");
		printf("Usage: %s /dev/input/eventX KindleIP Port Password keycode1 keycode2 keycode3\n", argv[0]);
		printf("keycode1 = Next page, keycode2 = Previous Page, keycode3 = menu\nSet keycode = 0 to disable corresponding mapping\n");
		return -1;
	}
	int btnarr[3] = {0};
	int i = 0;
	for (i = 0; i < 3 ; i++)
	{
		if ( i+5 < argc )
			btnarr[i] = atoi(argv[i+5]);
	}

	eventfd = open(argv[1], O_RDONLY);
	if (eventfd < 0) //failed
	{	
		printf("Can't read event\nPlease run as root!\n");
		return -1;
	}

	mypoll.fd =  eventfd;
	mypoll.events = POLLIN;

	while(1)
	{
		if(poll(&mypoll, 1, 10) > 0)
		{
			usleep(50000);
			int btn = getbtn(eventfd);
			if (btn == 0)  
				continue;
			//mode: 1 for next page, 2 for previous, 3 for menu
			int mode = -1;
			for (i = 0; i<3; i++)
			{
				if (btn == btnarr[i])
				{
					mode = i+1;
					break;
				}
			}
			//kindleip, port, mode

			printf("button %d, mode %d\n", btn, mode);
			sendcmd(argv[2], argv[3], argv[4], mode);
		}
	}
	close(eventfd);
	return 0;
}
