#!/usr/bin/python2
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__ = 'GPL v3'
__copyright__ = '2016, Eli Schwartz <eschwartz93@gmail.com>'
__docformat__ = 'restructuredtext en'

from calibre.ebooks.metadata.sources.amazon import Amazon

class AmazonAltCountry3(Amazon):

    name = 'Amazon.com Multiple Countries take 3'
    description = 'Downloads metadata and covers from a third alternative Amazon country portal. Works in tandem with the builtin plugin and Amazon.com Multiple Countries to enable downloading from multiple Amazon domains'
    author = 'Eli Schwartz'
    version = (1, 0, 0)
    minimum_calibre_version = (0, 8, 2)

    @property
    def domain(self):
        x = getattr(self, 'testing_domain', None)
        if x is not None:
            return x
        domain = self.prefs['domain']
        if domain not in self.AMAZON_DOMAINS:
            domain = 'uk'

        return domain
