#!/bin/busybox sh

###### possible values of "origin", origin means the point x=0 y=0
# TL: top left
# TR: top right
# BL: bottom left
# BR: bottom right


ksmroot=${ksmroot:-"/adds/kbmenu"}
ksmuser=${ksmuser:-"/mnt/onboard/.adds/kbmenu_user"}
prog=/bin/touch_simulate
thisparent=$(dirname $(dirname $(readlink -f $0)))
logfile=${thisparent}/logfile.txt
missingInput=${thisparent}/data/missing_part_01.dat


[ "$REQUEST_METHOD" == "POST" ] && read QUERY_STRING
echo "$(date +%Y%m%d_%H%M%S)" >> ${logfile}
echo "QUERY_STRING: $QUERY_STRING" >> ${logfile}
xvalue=$(echo "${QUERY_STRING}" | awk 'BEGIN{RS="\&"; FS="="} { if ($1=="screen_x") {print $2}}')
yvalue=$(echo "${QUERY_STRING}" | awk 'BEGIN{RS="\&"; FS="="} { if ($1=="screen_y") {print $2}}')
xmax=$(echo "${QUERY_STRING}" | awk 'BEGIN{RS="\&"; FS="="} { if ($1=="screen_xmax") {print $2}}')
ymax=$(echo "${QUERY_STRING}" | awk 'BEGIN{RS="\&"; FS="="} { if ($1=="screen_ymax") {print $2}}')

getparams=$(echo "${HTTP_REFERER}" | awk 'BEGIN{RS="\?";} { if (NR==2) {print $0}}')
origin=$(echo "${getparams}" | awk 'BEGIN{RS="\&"; FS="="} { if ($1=="origin") {print $2}}')

[ "x${origin}" == "x" ] && origin="undefined"

# remap coordiantes if necessary
case ${origin} in
  TL )
    touchX=$((xvalue))
    touchY=$((yvalue))
    ;;
  TR )
    touchX=$((yvalue))
    touchY=$((xmax-xvalue))
    ;;
  BL )
    touchX=$((ymax-yvalue))
    touchY=$((xvalue))
    ;;
  BR )
    touchX=$((xmax-xvalue))
    touchY=$((ymax-yvalue))
    ;;
  * ) #decide based on dimensions
    case ${xmax}x${ymax} in
      600x800|758x1024 ) # Touch (with exeptions) and Glo have the origin TR
        touchX=$((yvalue))
        touchY=$((xmax-xvalue))
        ;;
      * )
        touchX=$((xvalue))
        touchY=$((yvalue))
        ;;
    esac
    ;;
esac

# call
if [ -e $prog ]; then
  ${prog} -x ${touchX} -y ${touchY} -p 400 -a 0
  cat ${missingInput} > /dev/input/event1
else
  echo "$(date +%Y%m%d_%H%M%S): cannot find ${prog}" >> ${logfile}
fi


echo "touchX:${touchX}" >> ${logfile}
echo "touchY: ${touchY}" >> ${logfile}



echo "Content-type: text/html"
echo ""
echo "<html>"
echo "<body style='font-size:180%; color:white'>"
echo "<p>"
echo "$QUERY_STRING"
echo "</br>"
echo "new: x=${touchX} y=${touchY}"
echo "</br>"
echo "getparams:${getparams}"
echo "</br>"
echo "origin:${origin}"
echo "</p>"
echo "</body>"
echo "</html>"

exit 0
