#!/bin/sh


ksmroot=${ksmroot:-"/adds/kbmenu"}
ksmuser=${ksmuser:-"/mnt/onboard/.adds/kbmenu_user"}

set -e
stopanimation() {
  killall on-animator.sh
}
trap stopanimation EXIT

versionfilename=/mnt/onboard/.kobo/version
revinfofilename=/usr/local/Kobo/revinfo
patchbasedir=${ksmuser}/patchbase
kobolibdir=/usr/local/Kobo

if [ -e $versionfilename ]; then
  fwid=$(awk -F"," '{print $3}' $versionfilename)
else
  echo "failed_to_find_current_FW_version"
  exit
fi

if [ -e $revinfofilename ]; then
  revnum=$(awk '{print substr ($0, 0, 10)}' $revinfofilename)
else
  echo "failed_to_find_rev_number"
  exit
fi
patchdirorig="${patchbasedir}/${fwid}_${revnum}/orig"
therearefiles="false"
$ksmroot/scripts_intern/div/on-animator.sh &
for f in "${patchdirorig}/"*; do
  [ -e "${f}" ] && therearefiles="true" ||  break
  cp "${f}" "${kobolibdir}"
done
killall on-animator.sh
if [ "${therearefiles}" == "false" ]; then
  echo "no_backups_found"
fi
