#!/bin/sh

userid=0

urlbase="http://pip.cat/khd/kobo"

set -e
stopanimation() {
  killall on-animator.sh
}
trap stopanimation EXIT


ksmroot=${ksmroot:-"/adds/kbmenu"}
ksmuser=${ksmuser:-"/mnt/onboard/.adds/kbmenu_user"}
logfile=${ksmroot}/log/khd_download_patches.txt

versionfilename=/mnt/onboard/.kobo/version
revinfofilename=/usr/local/Kobo/revinfo
patchbasedir=${ksmuser}/patchbase


if [ -e $versionfilename ]; then
  fwid=$(awk -F"," '{print $3}' $versionfilename)
else
  echo "failed_to_find_current_FW_version"
  exit
fi

if [ -e $revinfofilename ]; then
  revnum=$(awk '{print substr ($0, 0, 10)}' $revinfofilename)
else
  echo "failed_to_find_rev_number"
  exit
fi

patchdir="${patchbasedir}/${fwid}_${revnum}"
infourl="${urlbase}/get_info.php?fwid=${fwid}&revnum=${revnum}&userid=${userid}"
echo "$(date)" > ${logfile}
echo "infourl: ${infourl}" >> ${logfile}

$ksmroot/scripts_intern/div/on-animator.sh &
jsonresp=$(wget -q -O - "${infourl}")


if [ "${jsonresp}" == "ERROR: Firmware not found!" ]; then
  echo "Cannot_find_profiles_for_this_FW_version"
  exit
fi

firmware=$(echo "${jsonresp}" | awk 'BEGIN {RS="\\{|\\}";FS=",|:"}  {if (index($1,"\"idfw\"") == 1) {gsub("\"","",$2); print $2}}')


profiles=$(echo "${jsonresp}" | awk 'BEGIN {RS="\\}\\}|profiles\":\\{"} {if (NR==2) {gsub(" ","_",$0); gsub("\"","",$0) ; print $0}}')
profiles=$(echo "${profiles}" | awk 'BEGIN {RS=","; FS=":"}  {if ($2 !~ "Default_profile") {print $1 ":["NR"]" $2}}')
optionlist=$(echo "${profiles}" | awk 'BEGIN{FS=":"; RS="\n"; ORS=" "} {print $2}')


killall on-animator.sh
##### menu
selectedoption=
selectedoption=$($ksmroot/kobomenu $optionlist return:arrowup.png -qws)
case "$selectedoption" in
  return)  echo "selection_cancelled";;
  *)
    selid="${selectedoption%%]*}]"
    echo "selid ${selid}" >> ${logfile}
    profile=$(echo "${profiles}" | awk -v selid="${selid}" 'BEGIN{FS=":"} {if (index($2,selid) == 1)  {print $1}}')
    echo "profile ${profile}" >> ${logfile}
    querystring="firmware=${firmware}&profile=${profile}"
    echo "querystring ${querystring}" >> ${logfile}
    mkdir -p "${patchdir}"
    echo "trying to download: ${patchdir}/patch.zip ${urlbase}/download.php\?${querystring}" >> ${logfile}
    $ksmroot/scripts_intern/div/on-animator.sh &
    wget -O "${patchdir}/patch.zip" "${urlbase}/download.php?${querystring}" &> /dev/null
    if [ $? -eq 0 ]; then
      cd "${patchdir}"
      rm -f "*.patch"
      unzip -oq "patch.zip"
      if [ $? -ne 0 ]; then
        echo "failed_to_unzip"
        exit
      fi
      rm -f "patch.zip"
    else
      echo "cannot_download_the_archive"
      exit
    fi
    selectedoption="EXIT";;
esac


echo "everything_seems_to_be_ok!"
