#!/bin/sh

ksmroot=${ksmroot:-"/adds/kbmenu"}
ksmuser=${ksmuser:-"/mnt/onboard/.adds/kbmenu_user"}

versionfilename=/mnt/onboard/.kobo/version
revinfofilename=/usr/local/Kobo/revinfo
patchbasedir=${ksmuser}/patchbase

if [ -e $versionfilename ]; then
  fwid=$(awk -F"," '{print $3}' $versionfilename)
else
  echo "failed_to_find_current_FW_version"
  exit
fi

if [ -e $revinfofilename ]; then
  revnum=$(awk '{print substr ($0, 0, 10)}' $revinfofilename)
else
  echo "failed_to_find_rev_number"
  exit
fi

patchdir="${patchbasedir}/${fwid}_${revnum}"
rm -f "${patchdir}/"*".patch"
